require 'rails_helper'
RSpec.describe VBMSJob::DBLogger do
  subject { VBMSJob::DBLogger.new(9999) }

  describe "#log" do
    it "should log an unencrypted request" do
      expect {subject.log(:unencrypted_request, unencrypted_body: "Cthulhu")}.to change {EvaluationLog.count}.by(1)
    end

    it "should log a request" do
      opts = {
        request_body: "<xml></xml>",
        response_code: "200",
        response_body: "<xml></xml>",
      }
      expect {subject.log(:request, opts)}.to change {EvaluationLog.count}.by(1)
    end

    it "should log a decrypted message" do
      opts = {
        request_body: "<xml></xml>",
        response_code: "200",
        response_body: "<xml></xml>",
      }
      expect {subject.log(:decrypted_message, opts)}.to change {EvaluationLog.count}.by(1)
    end

    it "should handle an unknown message" do
      opts = { unknown_opt: "something" }
      expect {subject.log(:unknown_message, opts)}.to change {EvaluationLog.count}.by(1)
    end
  end
end
