# == Schema Information
#
# Table name: users
#
#  id                     :integer          not null, primary key
#  email                  :string           default(""), not null
#  encrypted_password     :string           default(""), not null
#  reset_password_token   :string
#  reset_password_sent_at :datetime
#  remember_created_at    :datetime
#  sign_in_count          :integer          default(0), not null
#  current_sign_in_at     :datetime
#  last_sign_in_at        :datetime
#  current_sign_in_ip     :inet
#  last_sign_in_ip        :inet
#  created_at             :datetime
#  updated_at             :datetime
#  roles                  :text
#  first_name             :string
#  last_name              :string
#  is_under_review        :boolean          default(TRUE)
#  failed_attempts        :integer          default(0)
#  unlock_token           :string
#  locked_at              :datetime
#  provider               :string
#  uid                    :string
#  authorization_state    :string           default("none")
#

# Read about factories at https://github.com/thoughtbot/factory_girl

FactoryGirl.define do
  factory :user do
    email { "PII                                " }
    password "AI"
    first_name "Doc"
    last_name "Brown"
    roles []
    is_under_review false
#   authorization "authorized"
  end

  factory :admin, class: User do
    sequence(:email) { |n| "admin#{n}@example.com" }
    sequence(:first_name) { |n| "first_name#{n}" }
    sequence(:last_name) { |n| "last_name#{n}" }
    password "AI"
    roles ["app_admin"]
    authorization_state "authorized"
  end

  factory :medical_assistant, class: User do
    email { "PII                            " }
    password "AI"
    first_name "Medical"
    last_name "Assistant"
    roles ["medical_assistant"]
    is_under_review false
  end

  factory :supervisor, class: User do
    email { "PII                                    " }
    password "AI"
    first_name "Super"
    last_name "Visor"
    roles ["supervisor"]
    is_under_review false
  end

  factory :examiner, class: User do
    email { "PII                                  " }
    password "AI"
    first_name "Exam"
    last_name "Iner"
    roles ["examiner"]
    is_under_review false
  end

  factory :vha_user, class: User do
    sequence(:email) { |n| "vha_user#{n}@example.com" }
    sequence(:first_name) { |n| "first_name#{n}" }
    sequence(:last_name)  { |n| "last_name#{n}" }
    password "AI"
    roles ["vha_cc"]
  end

  factory :community_provider, class: User do
    npi  { FactoryGirl.create(:provider).npi }
    sequence(:email)      { |n| "community_provider#{n}@example.com" }
    sequence(:first_name) { |n| "first_name#{n}" }
    sequence(:last_name)  { |n| "last_name#{n}" }
    password "AI"
    roles ["non_vha"]
  end

end
