# == Schema Information
#
# Table name: facilities
#
#  id      :integer          not null, primary key
#  name    :string
#  content :json
#  visn_id :integer
#

FactoryGirl.define do

  # Default facility with sequentially generated name.
  # This facility will default to the first generated VISN (which this factory will
  # create if it doesn't already exist) so that all default facilities have the
  # same VISN.
  factory :facility do
    visn  { Visn.first }
    sequence(:name)  {|n| "Facility #{n} For Testing" }
  end

end
