# == Schema Information
#
# Table name: diagnoses
#
#  id                    :integer          not null, primary key
#  name                  :string
#  label                 :string
#  code                  :string
#  diagnosis_modifier_id :integer
#  created_at            :datetime         not null
#  updated_at            :datetime         not null
#  minor_system_id       :integer
#

FactoryGirl.define do
  factory :diagnosis_modifier do
    name "barney"
    label "Barney Rubble"
    mod_type "checkbox"
    list_values ["First", "Second"]
  end
  
  factory :diagnosis do
    sequence(:name){|n| "liver_injury_residuals_#{n+1000}"} 
    label "Has the Veteran had residual injuries of the liver?"
    code "7311"
    sequence(:position){ |n| n+1 } 
  end

  factory :diagnosis_with_diagnosis_modifier, :parent => :diagnosis do |diagnosis|
    features { build_list :diagnosis_modifier, 1 }
  end
end
