require 'rails_helper'

# This spec was generated by rspec-rails when you ran the scaffold generator.
# It demonstrates how one might use RSpec to specify the controller code that
# was generated by Rails when you ran the scaffold generator.
#
# It assumes that the implementation code is generated by the rails scaffold
# generator.  If you are using any extension libraries to generate different
# controller code, this generated spec may or may not pass.
#
# It only uses APIs available in rails and/or rspec-rails.  There are a number
# of tools you can use to make these specs even more expressive, but we're
# sticking to rails and rspec-rails APIs to keep things simple and stable.
#
# Compared to earlier versions of this generator, there is very limited use of
# stubs and message expectations in this spec.  Stubs are only used when there
# is no simpler way to get a handle on the object needed for the example.
# Message expectations are only used when there is no simpler way to specify
# that an instance is receiving a specific message.

RSpec.describe FullBodyEvaluationsController, :type => :controller do

  # This should return the minimal set of attributes required to create a valid
  # FullBodyEvaluation. As you add validations to FullBodyEvaluation, be sure to
  # adjust the attributes here as well.
  let(:valid_attributes) {
    skip("Add a hash of attributes valid for your model")
  }

  let(:invalid_attributes) {
    skip("Add a hash of attributes invalid for your model")
  }

  # This should return the minimal set of values that should be in the session
  # in order to pass any filters (e.g. authentication) defined in
  # FullBodyEvaluationsController. Be sure to keep this updated too.
  let(:valid_session) { {} }

  describe "GET index" do
    it "assigns all full_body_evaluations as @full_body_evaluations", cui: true do
      full_body_evaluation = FullBodyEvaluation.create! valid_attributes
      get :index, {}, valid_session
      expect(assigns(:full_body_evaluations)).to eq([full_body_evaluation])
    end
  end

  describe "GET show" do
    it "assigns the requested full_body_evaluation as @full_body_evaluation", cui: true do
      full_body_evaluation = FullBodyEvaluation.create! valid_attributes
      get :show, {:id => full_body_evaluation.to_param}, valid_session
      expect(assigns(:full_body_evaluation)).to eq(full_body_evaluation)
    end
  end

  describe "GET new" do
    it "assigns a new full_body_evaluation as @full_body_evaluation", cui: true do
      get :new, {}, valid_session
      expect(assigns(:full_body_evaluation)).to be_a_new(FullBodyEvaluation)
    end
  end

  describe "GET edit" do
    it "assigns the requested full_body_evaluation as @full_body_evaluation", cui: true do
      full_body_evaluation = FullBodyEvaluation.create! valid_attributes
      get :edit, {:id => full_body_evaluation.to_param}, valid_session
      expect(assigns(:full_body_evaluation)).to eq(full_body_evaluation)
    end
  end

  describe "POST create" do
    describe "with valid params" do
      it "creates a new FullBodyEvaluation", cui: true do
        expect {
          post :create, {:full_body_evaluation => valid_attributes}, valid_session
        }.to change(FullBodyEvaluation, :count).by(1)
      end

      it "assigns a newly created full_body_evaluation as @full_body_evaluation", cui: true do
        post :create, {:full_body_evaluation => valid_attributes}, valid_session
        expect(assigns(:full_body_evaluation)).to be_a(FullBodyEvaluation)
        expect(assigns(:full_body_evaluation)).to be_persisted
      end

      it "redirects to the created full_body_evaluation", cui: true do
        post :create, {:full_body_evaluation => valid_attributes}, valid_session
        expect(response).to redirect_to(FullBodyEvaluation.last)
      end
    end

    describe "with invalid params" do
      it "assigns a newly created but unsaved full_body_evaluation as @full_body_evaluation", cui: true do
        post :create, {:full_body_evaluation => invalid_attributes}, valid_session
        expect(assigns(:full_body_evaluation)).to be_a_new(FullBodyEvaluation)
      end

      it "re-renders the 'new' template", cui: true do
        post :create, {:full_body_evaluation => invalid_attributes}, valid_session
        expect(response).to render_template("new")
      end
    end
  end

  describe "PUT update" do
    describe "with valid params" do
      let(:new_attributes) {
        skip("Add a hash of attributes valid for your model")
      }

      it "updates the requested full_body_evaluation", cui: true do
        full_body_evaluation = FullBodyEvaluation.create! valid_attributes
        put :update, {:id => full_body_evaluation.to_param, :full_body_evaluation => new_attributes}, valid_session
        full_body_evaluation.reload
        skip("Add assertions for updated state")
      end

      it "assigns the requested full_body_evaluation as @full_body_evaluation", cui: true do
        full_body_evaluation = FullBodyEvaluation.create! valid_attributes
        put :update, {:id => full_body_evaluation.to_param, :full_body_evaluation => valid_attributes}, valid_session
        expect(assigns(:full_body_evaluation)).to eq(full_body_evaluation)
      end

      it "redirects to the full_body_evaluation", cui: true do
        full_body_evaluation = FullBodyEvaluation.create! valid_attributes
        put :update, {:id => full_body_evaluation.to_param, :full_body_evaluation => valid_attributes}, valid_session
        expect(response).to redirect_to(full_body_evaluation)
      end
    end

    describe "with invalid params" do
      it "assigns the full_body_evaluation as @full_body_evaluation", cui: true do
        full_body_evaluation = FullBodyEvaluation.create! valid_attributes
        put :update, {:id => full_body_evaluation.to_param, :full_body_evaluation => invalid_attributes}, valid_session
        expect(assigns(:full_body_evaluation)).to eq(full_body_evaluation)
      end

      it "re-renders the 'edit' template", cui: true do
        full_body_evaluation = FullBodyEvaluation.create! valid_attributes
        put :update, {:id => full_body_evaluation.to_param, :full_body_evaluation => invalid_attributes}, valid_session
        expect(response).to render_template("edit")
      end
    end
  end

  describe "DELETE destroy" do
    it "destroys the requested full_body_evaluation", cui: true do
      full_body_evaluation = FullBodyEvaluation.create! valid_attributes
      expect {
        delete :destroy, {:id => full_body_evaluation.to_param}, valid_session
      }.to change(FullBodyEvaluation, :count).by(-1)
    end

    it "redirects to the full_body_evaluations list", cui: true do
      full_body_evaluation = FullBodyEvaluation.create! valid_attributes
      delete :destroy, {:id => full_body_evaluation.to_param}, valid_session
      expect(response).to redirect_to(full_body_evaluations_url)
    end
  end

end
