require File.expand_path('../spec_helper', __FILE__)

describe CuiDeavtivateUserAccount do
  let(:params)  {
                  {
                    environment:      'development',
                    max_inactive_period: 90,
                    current_script:   'cui_deactivate_user_account',
                    pid:              1776
                  }
                }

  describe 'initialize (DeavtivateUsers.new(params))' do
    describe 'Params' do
      subject { params }

      describe 'Keys . . .' do
        it 'environment' do
          expect(subject).to have_key(:environment)
        end

        it 'max_inactive_period' do
          expect(subject).to have_key(:max_inactive_period)
        end

        it 'current_script' do
          expect(subject).to have_key(:current_script)
        end

        it 'pid' do
          expect(subject).to have_key(:pid)
        end
      end

      describe 'expected types' do
        it 'Params is a hash' do
          expect(subject.is_a?(Hash)).to be_truthy
        end

        describe 'param values' do
          it 'environment is a string' do
            expect(subject[:environment]).to be_a(String)
          end

          it 'max_inactive_period' do
            expect(subject[:pid]).to be_a(Integer)
          end

          it 'current_script is a string' do
            expect(subject[:current_script]).to be_a(String)
          end

          it 'pid is an integer' do
            expect(subject[:pid]).to be_a(Integer)
          end
        end

      end

      describe 'has expected values' do
        subject { CuiDeavtivateUserAccount.new(params) }

        it "environment value is correct" do
          expect(subject.instance_variable_get(:@environment)).to \
            eql('development')
        end

        it "pid value is correct" do
          expect(subject.instance_variable_get(:@pid)).to eql(1776)
        end

        it "current_script value is correct" do
          expect(subject.instance_variable_get(:@current_script)).to \
            eql('cui_deactivate_user_account')
        end

        it "max_inactive_period value is correct" do
          expect(subject.instance_variable_get(:@max_inactive_period)).to \
            eql(90)
        end
      end
    end

    describe 'Methods' do
      subject { CuiDeavtivateUserAccount.new(params) }
      it 'responds to exposed metods' do
        expect(subject).to respond_to(:run)
      end

    end
  end
end
