namespace :exam_requests do
  task load_from_excel: :environment do

    require 'spreadsheet'
    require 'fileutils'
    require 'active_support'
    require 'action_mailer'
    require 'set'

    ARGV.each {|a| task a.to_sym do ; end }
    filename = ARGV[1].to_s
    puts filename

    path = File.join(Rails.root.to_s, 'lib', 'tasks', 'exam_request', 'ExamRequestData.xls')
    template_path = File.join(Rails.root.to_s, 'lib', 'tasks', 'exam_request', 'ExamRequestTemplate.xml')

    file = File.open(template_path)
    template_contents = file.read
    #puts contents

    puts path
    book    = Spreadsheet.open path
    sheet0  = book.worksheet 0

  
    sheet0.each_with_index do |row, index|
      if index > 0
        contents = template_contents.clone
        puts "Processing..." + index.to_s

        contents.gsub! '###FIRST_NAME###', row[0]
        contents.gsub! '###LAST_NAME###', row[1]
        contents.gsub! '###FILE_NUMBER###', row[2].to_s
        contents.gsub! '###CLAIM_ID###', row[3]
        contents.gsub! '###SITE###', row[4]

      #  temp_file_name = 'exam_request_'+index.to_s+'.xml'
      #  path_to_file = File.join(Rails.root.to_s, 'lib', 'tasks', temp_file_name)
      #  File.write(path_to_file, contents)

        #post the data
        VlerDASJob.postNotification(contents)

        contents = ""
      end
     
    end 
  end

  task generate: :environment do
    require 'spreadsheet'
    require 'fileutils'
    require 'active_support'
    require 'action_mailer'
    require 'set'

    ARGV.each {|a| task a.to_sym do ; end }
    count = ARGV[1]
    #puts "Generating " + count + " ExamRequests."

    siteArg = ARGV[2]

    siteStr = ""
    if (siteArg != nil)
      siteFromDb = Site.find_by_name(siteArg)
      if (siteFromDb == nil)
        puts ""
        puts "Invalid site ::: " + siteArg
        puts "Please select one from the list ::: [QTC, VES, VetFed, Atlanta VA Medical Center, Chicago Medical Center]"
        
        abort ''
      else
        siteStr = siteFromDb.name
      end
    end
   
    if count == nil or count == ""
      puts "Please make sure you are invoking the command as specified below:"
      puts ""
      puts "rake exam_request:generate <number of exam requests>"
      puts ""
    else 
      template_path = File.join(Rails.root.to_s, 'lib', 'tasks', 'exam_request', 'ExamRequestTemplate.xml')

      file = File.open(template_path)
      template_contents = file.read
      
      site_array = ["QTC", "VetFed", "VES", "Atlanta VA Medical Center", "Chicago Medical Center"]
      temp = site_array.sample(1 + SecureRandom.random_number(site_array.count))

      $i = 1
      $num = count.to_i
      while $i <= $num  do
        contents = template_contents.clone

        first_name = "FName" + (SecureRandom.random_number(1000)).to_s
        last_name = "LName" + (SecureRandom.random_number(1000)).to_s
        file_number = SecureRandom.random_number(10000000)
        claim_id = SecureRandom.hex

        contents.gsub! '###FIRST_NAME###', first_name
        contents.gsub! '###LAST_NAME###', last_name
        contents.gsub! '###FILE_NUMBER###', file_number.to_s
        contents.gsub! '###CLAIM_ID###', claim_id

        if (siteStr == nil or siteStr == "")
          temp = site_array.sample(1 + SecureRandom.random_number(site_array.count))
          siteStr = temp[0].to_s
          contents.gsub! '###SITE###', siteStr

          puts "Generated Site ::: " + siteStr
          siteStr = ""
        else
          contents.gsub! '###SITE###', siteStr
          puts "Site Str ::: " + siteStr
        end

        contents.gsub! '###SITE###', siteStr

        #post the data
        VlerDASJob.postNotification(contents)
      
        puts("Generated and Processed...#$i" )
        $i +=1
      end
    end
  end
end
