# Clinician User Interface Application - Instructions for Windows Users

This guide needs to consider the main instructions on setting up CUI. ```see README.md```

Our setup has the cui application installed according to the following path:

c:\work\cui_work\cui

This document may reference certain directories for copying files or dlls. Use this directory path as a guide.
If you are using RubyMine we recommend creating bat scripts to set up the environment and launch RubyMine.
Here are examples of the bat scripts:

###cui_setup.bat
```
set GEM_HOME=C:\work\cui_work\gem_home
set PATH=C:\work\cui_work\dlls;C:\languages\ruby\Ruby23-x64\bin;%GEM_HOME%\bin;C:\utilities\devkit\bin\%PATH%
```

###cui_rm.bat
```
call cui_setup.bat
start "" "C:\ide\JetBrains\RubyMine 2017.2.2\bin\rubymine64.exe"
```

## Installation and Setup
* install cygwin if it is not installed
* run a DOS shell as administrator
* create .gemrc file in your user directory (i.e. c:\users\gbowman) and put the following line in the file:
    
    ```:ssl_verify_mode: 0```

* download the devkit at ```http://rubyinstaller.org/downloads```
* follow the instructions at ```http://github.com/oneclick/rubyinstaller/wiki/Development-Kit```
    - ruby dk.rb init
    - ruby dk.rb install
    
* download redis at ```https://github.com/MicrosoftArchive/redis/releases```
* get libcurl.dll from ```https://stackoverflow.com/questions/39377541/how-to-solve-libcurl-not-found-with-rails-on-windows``` and extract it to cui_work\dlls and make sure this directory is on your path
* uninstall bcrypt using (in the order specified):
    - gem uninstall bcrypt
    - gem uninstall bcrypt-ruby
* add to the development group in gemfile:
    - gem 'tzinfo-data', platforms: [:mingw, :mswin, :x64_mingw]
* install bcrypt using:
    - gem install bcrypt -v 3.1.11 --platform=ruby
* run the following commands to create and seed the database:
    - rake db:create
    - rake db:migrate
    - rake db:seed
* put the following line in .env.local:
    - export PUMA_DAEMONIZE=false #true is not supported on windows
    - export REDIS_HOST=127.0.0.1
    - export REDIS_URL=redis://$REDIS_HOST:$REDIS_PORT/$REDIS_DB_DEFAULT
    
## Sidekiq Setup
* put the following line into your .env.local file so that sidekiq logging will go into the environment log file
    - export SIDEKIQ_LOG_TO_RAILS = true

* Start sidekiq from a terminal window
    - rake sidekiq:start

