class AddFieldsFromExamRequest < ActiveRecord::Migration
  def change
  	add_column :exam_requests, :participating_system_name, :string

  	add_column :claims, :label, :string
  	add_column :claims, :end_product_code, :string
  	add_column :claims, :edipi, :string
  	add_column :claims, :participant_id, :string
  	add_column :claims, :gender, :string
  	add_column :claims, :vista_ien, :string
  	add_column :claims, :alternate_phone, :string
  	add_column :claims, :integration_control_number, :string
  	add_column :claims, :poa_vso_name, :string
  	add_column :claims, :poa_vso_number, :string
  	add_column :claims, :regional_office_id, :integer

  	create_table :preferred_geo_locations do |t|
  		t.string :address_1
  		t.string :address_2
  		t.string :address_3
  		t.string :city
  		t.string :zip
  		t.string :state
  		t.integer :claim_id

  		t.timestamps null: false
  	end

  	create_table :service_periods do |t|
  		t.date :entry_on_duty
  		t.date :service_end_date
  		t.string :branch_of_service
  		t.text :eras
  		t.integer :claim_id

  		t.timestamps null: false
  	end

  	create_table :regional_offices do |t|
  		t.string :station_number
  		t.text :physical_address
  		t.text :mailing_address
  		t.timestamps null: false
  	end

  end
end