class CreateSympDiagRelations < ActiveRecord::Migration
  def change
    create_table :symp_diag_relations do |t|
      t.integer :symptom_id
      t.integer :diagnosis_id

      t.timestamps null: false
    end
    remove_column :diagnoses, :symptom_id    
    add_index :symp_diag_relations, :symptom_id
    add_index :symp_diag_relations, :diagnosis_id
    add_index :symp_diag_relations, [:symptom_id, :diagnosis_id], unique: true     
  end
end
