# Load the Rails application.
require File.expand_path('../application', __FILE__)
require 'fileutils'

# Initialize the Rails application.
DrTurboTax::Application.initialize!

assets = "#{Rails.root}/public/assets/application-*"

#hack for the naughty deployers who deploy, to our test/prod environment, as development
# always use precompiled assets unless specified with env variable
if (ENV['DONT_PRECOMPILE_ASSETS']&.downcase.eql?('true') || Rails.env.development?)
  asset_files = Dir.glob(assets)
  if Rails.env.development? && ! asset_files.empty?
    asset_files.each do |f|
      FileUtils.mv(f, f + '.bak')
    end
  end
else
  #what if they flip from dev to test?
  bak_files = Dir.glob(assets + '.bak')
  bak_files.each do |f|
    FileUtils.mv(f, f.split('.bak').first)
  end
end
