class MusculoskeletalAnkleEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Musculoskeletal-Ankle', base_document: 'ankle.xml'

  EXAM_TO_XML_FIELD_MAP = [
    {"hasAnkylosisDegreesPlantarFlexion" => "plantarFlexionAnkylosisDegrees"},
    {"initialRomFlexion" => "plantarFlexionInitialDegrees"},
    {"repetitiveRomFlexion" => "plantarFlexionDelucaDegrees"},
    {"repeatedUseRomFlexion" => "plantarFlexionMitchellDegrees"},
    {"flareupRomFlexion" => "plantarFlexionFlareUpDegrees"},
    {"hasAnkylosisDegreesDorsiflexion" => "dorsiflexionAnkylosisDegrees"},
    {"initialRomDorsiflexion" => "dorsiflexionInitialDegrees"},
    {"repetitiveRomDorsiflexion" => "dorsiflexionDelucaDegrees"},
    {"repeatedUseRomExtension" => "dorsiflexionMitchellDegrees"},
    {"flareupRomDorsiflexion" => "dorsiflexionFlareUpDegrees"}
  ]
 
  def modify_document
   
    form = FML::Form.from_json(evaluation.doc.to_json)
    
    addJointObjectiveEvidenceTag(form, "objectiveFlareups") 
    addJointObjectiveEvidenceTag(form, "disabilityFactorsExcessFatigability")
    addJointObjectiveEvidenceTag(form, "disabilityFactorsWeakenedMovement") 
    addJointObjectiveEvidenceTag(form, "disabilityFactorsLackOfEndurance")
    addJointObjectiveEvidenceTag(form, "disabilityFactorsIncoordination")
    addJointObjectiveEvidenceTag(form, "romPainful")   

    hasArthritis = getValue(form, "hasArthritis")
    if hasArthritis
      addJointOtherDiagnosesTag(form, "hasArthritisType")
    end 

    addTag("ankf", "ankleDiagnoses", evaluation.evaluation_spec.title)
 
    addMalunionTag(form)
    addSubastragalarOrTarsalJointTag(form)

    add_presentable_symptoms(namespace: 'ankf', basename: 'ankle', excluded_fields: ["objectiveFlareups", "disabilityFactorsExcessFatigability", "disabilityFactorsWeakenedMovement", "disabilityFactorsLackOfEndurance", "disabilityFactorsIncoordination", "hasArthritisType", "romPainful", "malunionOfCalcaneousTalus", "malunionOfCalcaneousTalusType", "ankylosisSubastragalar", "ankylosisSubastragalarType"])

    EXAM_TO_XML_FIELD_MAP.each do |fact|
      exam_field_name = fact.keys.first
      xml_field_name = fact[exam_field_name]
      if form.fields[exam_field_name] && form.fields[exam_field_name].to_h.has_key?(:value)
        fact_node = Nokogiri::XML::Node.new("ankf:#{xml_field_name}", document)
        fact_node.content = form.fields[exam_field_name].value
        evaluation_root.xpath("ankf:ankleFacts").first << fact_node
      end
    end

    add_parent_evaluations(evaluation, "//ankf:ankleFacts")
  end

  private

  def addSubastragalarOrTarsalJointTag(form)
    ankylosisSubastragalar = getValue(form, "ankylosisSubastragalar")
    if ankylosisSubastragalar
      # This will give you the associated rating calculator value
      ankylosisSubastragalarValue = getRatingCalculatorValue(form, "ankylosisSubastragalar")
      ankylosisSubastragalarType = getValue(form, "ankylosisSubastragalarType")
      addTag("ankf", "ankleSymptoms", ankylosisSubastragalarValue + ankylosisSubastragalarType)
    end
  end

  def addMalunionTag(form)
     # This will give you 'true' or 'false'
    malunionOfCalcaneousTalus = getValue(form, "malunionOfCalcaneousTalus")
    if malunionOfCalcaneousTalus
      # This will give you the associated rating calculator value
      malunionOfCalcaneousTalusValue = getRatingCalculatorValue(form, "malunionOfCalcaneousTalus")
      malunionOfCalcaneousTalusType = getValue(form, "malunionOfCalcaneousTalusType")
      addTag("ankf", "ankleSymptoms", malunionOfCalcaneousTalusValue + malunionOfCalcaneousTalusType)
    end
  end

  def getValue(form, fieldName)
    form.fields[fieldName].value
  end

  def addJointObjectiveEvidenceTag(form, fieldName)
    fieldValue = getRatingCalculatorValue(form, fieldName)

    if fieldValue.to_s.strip.length > 0
      addTag("jf", "jointsObjectiveEvidence", fieldValue)
    end
  end
 
  def addTag(namespace, tagName, tagValue)
    tag = Nokogiri::XML::Node.new(namespace+":"+tagName, document)
    valueTag = Nokogiri::XML::Node.new(namespace+":value", document)
    valueTag.content = tagValue
    tag << valueTag
    evaluation_root.xpath("ankf:ankleFacts").first << tag
  end

  def addJointOtherDiagnosesTag(form, fieldName)
      fieldValue = getValue(form, fieldName)
      jointsOtherDiagnosesTag = Nokogiri::XML::Node.new("jf:jointsOtherDiagnoses", document)
      jointsOtherDiagnosesValueTag = Nokogiri::XML::Node.new("jf:value", document)
      jointsOtherDiagnosesValueTag.content = fieldValue
      jointsOtherDiagnosesTag << jointsOtherDiagnosesValueTag
      evaluation_root.xpath("ankf:ankleFacts").first << jointsOtherDiagnosesTag
  end

  def getRatingCalculatorValue(form, fieldName)
    fields = evaluation.evaluation_spec.ratings_calculator_fields.select do |h|
      #puts h
      if h[:name] == fieldName
        h
      end
    end
    filteredFieldValue = fields.collect do |ratings_calculator_field|
      form_field = form.fields[ratings_calculator_field[:name]]

      if form_field && (form_field.value == true || form_field.value == ratings_calculator_field[:calculator_value])
        ratings_calculator_field[:calculator_value]
      end
    end.compact
    filteredFieldValue[0]
  end
end
