class InfectiousDiseaseEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Infectious Diseases', base_document: 'infectious-diseases.xml'

  def modify_document
    evaluation_root.xpath("cbsf:commonBodySystemFacts/cbsf:diagnoses/cbsf:value").first.content = evaluation.evaluation_spec.title
    add_presentable_symptoms(namespace: 'cbsf', basename: 'commonBodySystem', root: nil, symptoms_element: 'symptoms')

    add_parent_evaluations(evaluation, "//cbsf:commonBodySystemFacts")
  end
end
