class GenitourinaryEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Genitourinary', base_document: 'genitourinary.xml'
  NUMERIC_FACT_FIELD_NAMES = ["bun", "creatinine", "lowerLimitCreatinine", "upperLimitCreatinine"]
  SELECT_FACT_FIELD_NAMES = ["leftTesticle", "rightTesticle"]
  OTHER_SYMPTOMS = ["superapubicCystotomy", "catheterDrainageRequired", "hasAttacksOfColicFrequency", "complications", "hasCondition", "lastYear", "hasRecurrentStonesDietRequired", "hasRecurrentStonesDrugRequired", "hasRecurrentStonesInvasiveProceduresRequired", "hasRecurrentStonesNonInvasiveProceduresRequired", "hasRecurrentStones", "hasPenileDeformity", "hasErectileDysfunction", "hasPenisRemovalExtent", "hasConditionSymptomatic", "multipleUrethroperinealFistulae", "kidneyFunctionImpaired", "isActive", "inTreatment", "renalLabHeader", "catheterDrainageNotRequired", "noSignsOfInfection", "lossOfErectilePower"]
  
  def modify_document
    evaluation_root.xpath("gf:genitourinaryFacts/gf:genitourinaryDiagnoses/gf:value").first.content = evaluation.evaluation_spec.title
    form = FML::Form.from_json(evaluation.doc.to_json)
        
    add_presentable_symptoms(namespace: 'gf', basename: 'genitourinary', excluded_fields: OTHER_SYMPTOMS + NUMERIC_FACT_FIELD_NAMES + SELECT_FACT_FIELD_NAMES)

    # hack to get 'In remission' to show up; should be removed when hidden fields happen
    if form.fields["isActive"] && form.fields["inTreatment"]
      if form.fields["isActive"].value == false and form.fields["inTreatment"].value == false
        add_other_diagnoses_node("In remission")
      end
    end
    
    ratings_calculator_fields = evaluation.evaluation_spec.ratings_calculator_fields
    ratings_calculator_fields.each do |ratings_calculator_field|
      field_name, calculator_value = ratings_calculator_field[:name], ratings_calculator_field[:calculator_value]
      if OTHER_SYMPTOMS.include?(field_name)
        if form.fields[field_name].value == true || form.fields[field_name].value == calculator_value
          add_other_diagnoses_node(calculator_value)
        elsif form.fields[field_name].type == "markdown" && field_conditions_met(form, field_name) # hack to get 'Rate residuals to show up; should be removed when FML supports hidden fields.
          add_other_diagnoses_node(calculator_value)
        end
      end
    end
        
    NUMERIC_FACT_FIELD_NAMES.each do |fact_field_name|
      if form.fields[fact_field_name] && form.fields[fact_field_name].to_h.has_key?(:value)
        fact_node = Nokogiri::XML::Node.new("gf:#{fact_field_name}", document)
        fact_node.content = form.fields[fact_field_name].value
        evaluation_root.xpath("gf:genitourinaryFacts").first << fact_node
      end
    end
    
    SELECT_FACT_FIELD_NAMES.each do |fact_field_name|
      if form.fields[fact_field_name] && form.fields[fact_field_name].to_h.has_key?(:value)
        fact_node = Nokogiri::XML::Node.new("gf:#{fact_field_name}", document)
        form.fields[fact_field_name].options.each do |option|
          if option["value"] == form.fields[fact_field_name].value
            fact_node.content = option["ratingCalculator"]
            evaluation_root.xpath("gf:genitourinaryFacts").first << fact_node
            break
          end
        end
      end
    end

    add_parent_evaluations(evaluation, "//gf:genitourinaryFacts")
  end
  
  def add_diagnoses_node(calculator_value)
    add_value_node(calculator_value, "gf:genitourinaryDiagnoses")
  end
  
  def add_other_diagnoses_node(calculator_value)
    add_value_node(calculator_value, "gf:genitourinaryOtherDiagnoses")
  end
  
  def add_value_node(calculator_value, subnode_name)
    value_node = Nokogiri::XML::Node.new("gf:value", document)
    value_node.content = calculator_value
    symptoms_node = Nokogiri::XML::Node.new(subnode_name, document)
    symptoms_node << value_node
    evaluation_root.xpath("gf:genitourinaryFacts", document.namespaces).first << symptoms_node
  end  
  
  def field_conditions_met(form, field_name)
    conditional_on = form.fields[field_name].conditional_on
    negate = conditional_on.starts_with? "!"
    conditional_on = conditional_on[1..-1] if negate
    return form.fields[conditional_on].value == true ? !negate : negate
  end
end
