# == Schema Information
#
# Table name: support_requests
#
#  id                    :integer          not null, primary key
#  created_at            :datetime         not null
#  updated_at            :datetime         not null
#  ticket_number         :string           not null
#  first_name            :string           not null
#  last_name             :string           not null
#  customer_phone        :string           not null
#  customer_email        :string           not null
#  customer_organization :string           not null
#  customer_site         :string           not null
#  issue_description     :string           not null
#  severity              :integer
#  details               :string
#

class SupportRequest < ActiveRecord::Base
  validates  :ticket_number, presence: true
  validates  :first_name,  presence: true
  validates  :last_name,  presence: true
  validates  :customer_organization,  presence: true
  validates  :customer_site,  presence: true
  validates  :issue_description,  presence: true

	validates  :customer_email,  presence: true,
  	format: { with: /\w+@\w+\.{1}[a-zA-Z]{2,}/,
  						message: 'Invalid email format.' }

	validates  :customer_phone, presence: true,
		format: { with: /\A?\(?\d{3}\)?[- ]?\d{3}[- ]?\d{4}\z/,
              message: 'Invalid phone number format.' }

end
