# == Schema Information
#
# Table name: providers_users
#
#  id          :integer          not null, primary key
#  provider_id :integer
#  user_id     :integer
#

class ProvidersUser < ActiveRecord::Base
  belongs_to :provider
  belongs_to :user

  validate :must_have_non_vha_user

private

  def must_have_non_vha_user
    unless user.is_non_vha?
      errors.add(:not_community_provider, "Only Non-VHA users can be linked to providers.")
    end
  end

end
