# == Schema Information
#
# Table name: evaluations
#
#  id                            :integer          not null, primary key
#  evaluation_spec_id            :integer
#  doc                           :json
#  created_at                    :datetime
#  updated_at                    :datetime
#  claim_id                      :integer
#  completed_at                  :datetime
#  primary_evaluation_id         :integer
#  guid                          :string
#  reviewed_at                   :datetime
#  vha_user_vista_access_code    :string
#  vha_user_vista_verify_code    :string
#  vha_user_electronic_signature :string
#  user_id                       :integer
#  assigner_id                   :integer
#  examination_id                :integer
#

class FullBodyEvaluation < Evaluation

  include FullBodyEvaluationsHelper
  @evaluation_template = nil
  @html_repository = nil

  after_initialize :load_the_template_and_the_html_repository

  def html_document_fragment
    return @html_repository.document_fragment
  end

  def html_for_diagnoses
    return @html_repository.raw_html
  end
  
  def to_xml(render_pdf=true)
#old    EvaluationPresenter.render(self, render_pdf)
    # Generate the XML based on the contents of the @html_repository

    examResponseXml = buildExamResponseXml(self)

    return examResponseXml
  end
  
  def exam_responses
    return the_exam_responses_for(self)
  end
  
  def to_html
    return self.html_for_diagnoses
  end

  def to_pdf
    the_result = WickedPdf.new.pdf_from_string(self.to_html)
#    return 'TBD-PDF'
    return the_result
  end
  
  def to_text
    the_result = render_txt
    return the_result
  end
  
  def to_txt
    self.to_text
  end
  
  def pdf_file_name
    return 'CUI-Evaluation-' + self.guid + '.pdf'
  end
  
  def text_file_name
    return 'CUI-Evaluation-' + self.guid + '.txt'
  end
  
  
  def update_all_contents(the_params) # was update
    the_evaluation_fields = @html_repository.document_fragment

    # clear all of the checkboxes (and radio buttons), performing attendant operations
    the_checked_checkboxes = the_evaluation_fields.css( 'input[type="checkbox"][checked="checked"]' )
    the_checked_checkboxes.each do | the_checked_checkbox |
        the_checked_checkbox.attributes['checked'].remove
    end
    the_checked_radio_buttons = the_evaluation_fields.css( 'input[type="radio"][checked="checked"]' )
    the_checked_radio_buttons.each do | the_checked_radio_button |
        the_checked_radio_button.attributes['checked'].remove
    end    
    the_selected_options = the_evaluation_fields.css( 'option[selected="selected"]')
    the_selected_options.each do |the_option_to_clear|
      the_option_to_clear.attributes['selected'].remove
    end

    # set all visibility to hidden
    the_evaluation_fields.css( '[style="display:initial"]' ).each do | the_field_to_hide |
      the_field_to_hide['style'] = "display:none"
    end

    # set all bumps to zero TBD
    the_params.each do |the_parameter_name, the_value|
      if( a_form_field_name_is_represented_by( the_parameter_name ) )
        the_field_type = 'input'
        the_suffix = ''
        the_trimmed_parameter_name = the_parameter_name
        if the_parameter_name.end_with?('-yes_no')
          the_trimmed_parameter_name = the_parameter_name.split('-yes_no').first
          case the_value
            when ''         then  the_suffix = '-no'
            else                  the_suffix = '-yes'
          end
        elsif the_parameter_name.end_with?('-yes_no_na')
          the_trimmed_parameter_name = the_parameter_name.split('-yes_no_na').first
          case the_value
            when 'No'         then  the_suffix = '-no'
            when 'NA'         then  the_suffix = '-na'
            else                    the_suffix = '-yes'
          end               
        elsif the_parameter_name.end_with?('-yes_no_na_other')
          the_trimmed_parameter_name = the_parameter_name.split('-yes_no_na_other').first
          case the_value
            when 'No'         then  the_suffix = '-no'
            when 'NA'         then  the_suffix = '-na'
            when 'Other'      then  the_suffix = '-other'              
            else                    the_suffix = '-yes'
          end          
        end
        if the_parameter_name.end_with? "-select"
          the_field_type = "select"
        elsif the_parameter_name.include? "textarea"
          the_field_type = "textarea" 
        end
            
#        if the_trimmed_parameter_name.include? " "
#          # This was a debugging conditional. Probably can be removed now.
#        end
         
        # For checkboxgroups need to iterate through and process only the selected options.
        if the_parameter_name.include? "checkboxgroup"
          the_fields_to_modify = the_evaluation_fields.css( the_field_type + '#' + the_trimmed_parameter_name + the_suffix )
          the_fields_to_modify.each do |f|
            if the_params[the_trimmed_parameter_name].include? f[:value]
              process_the_form_changes_using( the_evaluation_fields, f, the_value )            
            end
          end
        else  
          the_field_to_modify = the_evaluation_fields.css( the_field_type + '#' + the_trimmed_parameter_name + the_suffix ).first  
          process_the_form_changes_using( the_evaluation_fields, the_field_to_modify, the_value )
        end
      end
    end
    # Get the fields out of the params. Process the fields and update the values in 
    # the html repository. Save the html repository
    @html_repository.stores(the_evaluation_fields)
  end
  

private

  def render_txt
    action_view.render  template: "full_body_evaluations/show.txt.erb",
                        layout:   nil,
                        locals:   { full_body_evaluation: self, claim: self.claim, form: self.html_document_fragment }
  end

  def action_view
    view = ActionView::Base.new
    view.view_paths = ActionController::Base.view_paths
    view.class_eval do
      include Rails.application.routes.url_helpers
      include ApplicationHelper
#      include EvaluationsHelper
      include FullBodyEvaluationsHelper
    end
    view
  end


  def a_form_field_name_is_represented_by( the_string_to_check )
    return the_string_to_check.start_with?('symptom','diagnosis','question','visibility')
  end

  def load_the_evaluation_template
    @evaluation_template = EvaluationTemplate.find_by(name: 'full_body_evaluation')
  end


  def load_the_html_repository
    self.create_guid
    the_working_repository_name = 'full_body_evaluation_' + self.guid
#    @html_repository = NokogiriEnabledHtmlRepository.find_by(name: 'full_body_evaluation' )
    @html_repository = NokogiriEnabledHtmlRepository.find_by(name: the_working_repository_name)
    if( @html_repository == nil)
#        @html_repository = NokogiriEnabledHtmlRepository.create(name: 'full_body_evaluation' )
        @html_repository = NokogiriEnabledHtmlRepository.create(name: the_working_repository_name)
        @html_repository.stores(@evaluation_template.form)
        # load the html repository from the template
    end
  end
  
  
  def load_the_template_and_the_html_repository
    load_the_evaluation_template
    load_the_html_repository
  end
  
  def perform_the_form_modifications_indicated_by( the_document_fragment, the_controlling_field )
    set_dependent_visibility_based_on( the_document_fragment, the_controlling_field )
    bump_dependent_elements_based_on( the_controlling_field )
  end

  def set_dependent_visibility_based_on( the_document_fragment, the_controlling_field )
    if( not the_controlling_field['visibility_dependents'].nil? )
      the_controlling_field['visibility_dependents'].split( ',' ).each do | the_name_of_the_field_to_modify |
        the_field_to_modify = the_document_fragment.css( '#' + the_name_of_the_field_to_modify ).first
if( not the_field_to_modify.nil? ) #cs stopgap fix because of -yes and -no suffixes. This should be more robust
        if visibility_is_specified_by( the_controlling_field )
          the_field_to_modify.present? ? (the_field_to_modify['style'] = 'display:initial') : false
        else
          the_field_to_modify.present? ? (the_field_to_modify['style'] = 'display:none') : false
        end
end
      end
    end
  end
  
  def visibility_is_specified_by( the_field_to_check )
    the_field_type = the_field_to_check['type']
    case the_field_type
      when 'checkbox', 'radio'
        return( the_field_to_check['checked'] == 'checked' )
      else
    end
  end

  def bump_dependent_elements_based_on( the_controlling_field )
    #TBD
  end

  def process_the_form_changes_using( the_document_fragment, the_controlling_field, the_new_value )
    case the_controlling_field.name
      when 'input'
        the_field_type = the_controlling_field[:type]
        case the_field_type
          #only comes in when it is checked, so only need to check for values which mean NOT CHECKED
          when 'checkbox', 'radio'
            if not the_new_value.nil?
              the_controlling_field['checked'] = 'checked'
              perform_the_form_modifications_indicated_by(the_document_fragment, the_controlling_field)
            end
        end
      when 'select'
        the_value_array = Array(the_new_value)
        the_value_array.each do |the_value_to_use|
          the_controlling_field.children.each do |the_option_field_to_check|
            if(the_option_field_to_check['value']==the_value_to_use)
              the_option_field_to_check['selected'] = 'selected'
            end
          end
        end
        perform_the_form_modifications_indicated_by(the_document_fragment, the_controlling_field)
      when 'textarea'
        the_controlling_field['value'] = the_new_value
        the_controlling_field.content = the_new_value
      else
    end
  end

  
end
