# == Schema Information
#
# Table name: examination_schedules
#
#  id                :integer          not null, primary key
#  examination_id    :integer
#  reschedule_reason :text
#  active            :boolean
#  exam_date_time    :datetime
#  created_at        :datetime         not null
#  updated_at        :datetime         not null
#

class ExaminationSchedule < ActiveRecord::Base

  belongs_to :examination

  CANCEL_CODES = {
    'N' => 'No Show',
    'C' => 'Cancelled by clinic',
    'NA' => 'No-show & auto re-book',
    'CA' => 'Cancelled by clinic & auto re-book',
    'I'  => 'Inpatient appointment',
    'PC' => 'Cancelled by patient',
    'PCA' => 'Cancelled by patient & auto-rebook',
    'NT'  => 'No action taken'
  }

  CANCEL_REASONS = {
    '1'  => 'Weather',
    '2'  => 'Inpatient status',
    '3'  => 'Patient death',
    '4'  => 'Travel difficulty',
    '5'  => 'Unable to keep appointment',
    '6'  => 'Death in family',
    '7'  => 'Clinic staffing',
    '8'  => 'Scheduling conflict/error',
    '9'  => 'Patient not eligible',
    '10' => 'Appointment no longer required',
    '11' => 'Other',
    '12' => 'Transfer opt care to other VA',
    '13' => 'Clinic cancelled'
  }

  def self.active_date_time
  	 active_schedule = self.where(active: true).first
  	 active_schedule.try(:exam_date_time).try(:present?) ? active_schedule.exam_date_time.to_datetime : ''
  end
end
