# == Schema Information
#
# Table name: examination_review_questionnaire
#
#  id                                              :integer          not null, primary key
#  claim_folder_reviewed                           :boolean
#  reviewed_not_indicated                          :boolean
#  reviewed_military_service_treatment_records     :boolean
#  reviewed_military_service_personnel_records     :boolean
#  reviewed_military_enlistment_examination        :boolean
#  reviewed_military_separation_examination        :boolean
#  reviewed_military_post_deployment_questionnaire :boolean
#  reviewed_dod_form_214_separation_documents      :boolean
#  reviewed_vha_treatment_records                  :boolean
#  reviewed_civilian_medical_records               :boolean
#  reviewed_interviews_with_collateral_witnesses   :boolean
#  reviewed_at                                     :datetime
#  reviewed_by                                     :integer
#  not_requested                                   :boolean
#  va_claims_file                                  :boolean
#  va_e_folder                                     :boolean
#  cprs                                            :boolean
#  no_records_were_reviewed                        :boolean
#  other                                           :boolean
#  other_text                                      :text
#  evidence_comments                               :boolean
#  evidence_comments_text                          :text
class ExaminationReviewQuestionnaire < ActiveRecord::Base
  belongs_to :examination

  RECORD_FIELD_LABEL_MAP = {
    :reviewed_not_indicated => "Not indicated",
    :reviewed_military_service_treatment_records => "Military service treatment records",
    :reviewed_military_service_personnel_records => "Military service personnel records",
    :reviewed_military_enlistment_examination => "Military enlistment examination",
    :reviewed_military_separation_examination => "Military separation examination",
    :reviewed_military_post_deployment_questionnaire => "Military post-deployment questionnaire",
    :reviewed_dod_form_214_separation_documents => "Department of Defense Form 214 Separation Documents",
    :reviewed_vha_treatment_records => "Veterans Health Administration medical records (VA treatment records)",
    :reviewed_civilian_medical_records => "Civilian medical records",
    :reviewed_interviews_with_collateral_witnesses => "Interviews with collateral witnesses (family and others who have known the veteran before and after military service)"
  }

  EVIDENCE_FIELD_LABEL_MAP = {
    :not_requested => "Not Requested",
    va_claims_file: "VA claims file (hard copy paper C-file)",
    va_e_folder: "VA e-folder (VBMS or Virtual VA)",
    cprs: "CPRS",
    no_records_were_reviewed: "No records were reviewed",
    other: "Other (please identify other evidence reviewed):",
    evidence_comments: "Evidence comments:"
  }
end
