# == Schema Information
#
# Table name: notifications
#
#  id         :integer          not null, primary key
#  created_at :datetime         not null
#  updated_at :datetime         not null
#

class AppointmentScheduledEvent < Notification
  include AppointmentObjectHelper

  def build_notification(type, claim_id, examination, examination_schedule, site_id)
    path = File.join(Rails.root.to_s, 'app', 'xml', 'templates', 'appointment_scheduled_event.xml')
    @document = Nokogiri::XML(File.open(path))

    apptScheduledEvent = XmlHelper.getDoc(@document, 'AppointmentScheduledEvent')

    requestObject = RequestObject.all.order('created_at desc').find_by_claim_id claim_id
    request_object_doc = Nokogiri::XML(requestObject.xml)
    examSchedulingRequestCreatedEvent = XmlHelper.getDoc(request_object_doc, 'ExamSchedulingRequestCreatedEvent')

    # This eventId should be returned by this method
    eventId = SecureRandom.uuid
    apptScheduledEvent['eventId'] = eventId

    examAppointmentId = ""
    if (type == "RESCHEDULE")
      rescheduleEventDoc = getRescheduleEventDoc(examination, examination_schedule)
      apptScheduledEvent['previousEvent'] = rescheduleEventDoc['eventId']

      clinician = User.find_by_id(examination.clinician)
      apptScheduledEvent['nameOfExaminer'] = clinician.first_name + " " + clinician.last_name
      apptScheduledEvent['examAppointmentId'] = rescheduleEventDoc['examAppointmentId']
      examAppointmentId = rescheduleEventDoc['examAppointmentId']
    else
      examAppointmentId = SecureRandom.uuid
      apptScheduledEvent['examAppointmentId'] = examAppointmentId
    end

    apptScheduledEvent['eventDtg'] = Time.now.utc.iso8601 
    apptScheduledEvent['modelVersion'] = examSchedulingRequestCreatedEvent['modelVersion']
    
    #FIX ME
    #apptScheduledEvent['scheduledDateTime'] = "2016-05-01T13:20:00Z"
    
    site = Site.find_by_id site_id
    
    if (site != nil)
      examiningFacility = XmlHelper.getDoc(@document, 'ExaminingFacility')
      examiningFacility['id'] = SecureRandom.uuid
      examiningFacility['name'] = site.name

      address1 = XmlHelper.getDoc(@document, 'Address1')
      address1.content = site.address
      city = XmlHelper.getDoc(@document, 'City')
      city.content = site.city
      state = XmlHelper.getDoc(@document, 'State')
      state.content = site.state
      zipCode = XmlHelper.getDoc(@document, 'ZipCode')
      zipCode.content = site.zip_code
      country = XmlHelper.getDoc(@document, 'Country')
      country.content = site.country
    end
    
    eventSourceDoc = XmlHelper.getDoc(apptScheduledEvent, 'EventSource')
    eventSourceDoc['participatingSystemName'] = "VBA Contractor"
    eventSourceDoc['contractorName'] = site.name
    
    originatingSystemDoc = XmlHelper.getDoc(@document, 'OriginatingSystem')
    originatingSystemDoc['participatingSystemName'] = "VBA Contractor"
    originatingSystemDoc['contractorName'] = site.name

    @document.root << originatingSystemDoc

    destinationDoc = XmlHelper.getDoc(@document, 'Destination')
    destinationDoc['participatingSystemName'] = "VBMS"
    
    @document.root << destinationDoc
    
    if (examination != nil)
      apptScheduledEvent['scheduledDateTime'] = examination_schedule.exam_date_time.iso8601
    else
      raise Exception, "Examination cannot be empty"
    end
    contentions = examination.contentions
    if contentions != nil && contentions.length > 0
        examRelatedContentionUuidsDoc = XmlHelper.getDoc(apptScheduledEvent, "ExamRelatedContentionUuids")
        contentions.each_with_index do |contention, index|
    
          if contention != nil
            uuidValueTag = XmlHelper.createTag(document, "UuidValue")
  
            uuidValueTag.content = contention.exam_related_contention_id
  
            examRelatedContentionUuidsDoc << uuidValueTag
          else
            raise Exception, "Contention cannot be nil while constructing an AppointmentScheduledEvent"
          end
        end
        if (type == "RESCHEDULE")
          handleAppointmentRescheduleEvent(apptScheduledEvent, examAppointmentId)
        else
          handleAppointmentScheduledEvent(apptScheduledEvent, examination, examAppointmentId, contentions)
        end
    else
      raise Exception, "Contentions cannot be empty"
    end
    @document.root << apptScheduledEvent
    return eventId
  end

  def getRescheduleEventDoc(examination, examination_schedule)
    @appointmentObjects = AppointmentObject.where("examination_identifier = ? and active = true",  examination.identifier)
    appointmentObjectDoc = Nokogiri::XML(@appointmentObjects[0].xml)
    rescheduleRequestEvent = XmlHelper.getDoc(appointmentObjectDoc, 'RescheduleRequestEvent')
    return rescheduleRequestEvent
  end
end
