class ReferralNotificationMailer < ApplicationMailer
  before_filter :check_sanitize
  default from: ENV['EMAIL_USER']

  def check_sanitize()
    SanitizeEmail.force_sanitize = EMAIL_SANITIZE
  end

  def referral_notification_email(referral,user, params = nil)
    # Emails coordinator when referral is ready for review
    @referral        = referral
    @user            = user
    @co_ordinator    = @referral.coordinator_id
    @email_to        = User.find(@co_ordinator).email
    if params
      @medical_records_ready = params[:medical_records_ready]
      @mr_comments           = params[:mr_comments]
      @referral_complete_status  = params[:referral_complete_status]
      @rr_comments           = params[:rr_comments]
    end
    mail(   to:       @email_to,
            subject:  "Medical Documents Ready for Review"
        )
  end
end
