class ProviderNotificationMailer < ApplicationMailer
  before_filter :check_sanitize
  default from: ENV['EMAIL_USER']

  def check_sanitize()
    SanitizeEmail.force_sanitize = EMAIL_SANITIZE
  end

  def provider_notification_email(referral)
    # Emails provider when referral status is changed to Request Information
    @referral        = referral
    @provider        = @referral.provider
    @email_to        = @provider.users.pluck(:email)
    mail(      to:   @email_to,
            subject:  "CPP Information Request"
        )
  end

  def provider_scheduled_notification_email(referral)
    #Emails provider when referral status is changed to Scheduled
    @referral        = referral
    @provider        = @referral.provider
    @email_to        = @provider.users.pluck(:email)
    mail(      to:   @email_to,
            subject:  "New Veteran Referral"
        )
  end

  def provider_upload_records_reminder_email(referral)
    @referral        = referral
    @provider        = @referral.provider
    @email_to        = @provider.users.pluck(:email)

    # To-Do:
    # This line should be removed. It prevents the errors that a 'To' email address is not present
    @email_to        = @email_to.empty? ? ENV['EMAIL_USER'] : @email_to

    @appointments    = @referral.referral_appointments.needs_reminder

    # To send reminder for multiple appointments under the same referral
    @appointments.each do |appointment|
      @appt = appointment
      mail(   to:       @email_to,
              subject:  "Please Update CPP Medical Records"
          )
    end
  end
end
