module ExaminationsHelper
	include DashboardsHelper

  def boilerplate_messages_for(examination=self)
    unique_boilerplate_messages = []
    examination.contentions.each do |contention|
      contention.dbq_informations.each do |single_dbq_info|
        unique_boilerplate_messages = unique_boilerplate_messages | single_dbq_info.boilerplate_messages
      end
    end
    return unique_boilerplate_messages
  end

  def dbq_information_for(examination=self)
    unique_dbq_information = []
    examination.contentions.each do |contention|
      unique_dbq_information = unique_dbq_information | contention.dbq_informations
    end
    return unique_dbq_information
  end

	def submission_buttons(examination)
		name = examination.name
		code = examination.code
		statuses = ['Ready to be Scheduled','Pending','Scheduled']
		link = ""

		if statuses.exclude?(name) && code != ExaminationStateHelper::RESCHEDULE
			link = link_to('Ready for Review', edit_examination_path(examination, status: 'completed'), class: 'button')
   	end

   	if name == "Reviewed"
    	link = link_to 'Submit', edit_examination_path(examination, status: "reviewed"), class: "button"
    end

    if name == "Reviewed" && examination.already_submitted?
      link = link_to 'Resubmit', edit_examination_path(examination, status: "reviewed"), class: "button"
    end

   	link
  end

  def reviewed_veterans_va_claim_folder exam
    exam.examination_review_questionnaire.claim_folder_reviewed
  end

  def valid_date_string(date_string, format="%m/%d/%y")
    begin
      Date.strptime(date_string, format) if date_string.present?
    rescue
    end
  end
end
