module ExamRequestHelper
  include ContentionObjectHelper, RequestObjectHelper

  def processExamSchedulingRequestCreatedEvent(exam_request_xml, exam_request_hash)
    ActiveRecord::Base.transaction do
      #setDocument(exam_request_xml)
      examSchedulingRequestCreatedEvent = exam_request_hash['feed']['entry']['content']['ExamManagementEventNotification']['ExamSchedulingRequestCreatedEvent']
      claim_information = examSchedulingRequestCreatedEvent['ClaimInformation']
      veteran_service_member_info = claim_information['VeteranServiceMemberInfo']
      ssn = "" # ssn_assignment({vet_info: veteran_service_member_info})
      vbmsClaimId = claim_information['claimId']
      vista_ien = claim_information['VeteranServiceMemberInfo']['vistaIen']

      @claim = create_or_update_claim({claim_info: claim_information,
                                      vet_info: veteran_service_member_info,
                                      ssn: ssn,
                                      vbms_claim_id: vbmsClaimId,
                                      vista_ien: vista_ien})

#      create_geo_location({claim_id: @claim.id, vet_info_xml: veteran_service_member_info})
#      create_service_periods({claim_id: @claim.id, vet_info_xml: veteran_service_member_info})
#      create_regional_office({vet_info_xml: veteran_service_member_info})

      orig_notification = Nokogiri::XML(exam_request_xml)
      destination_doc = XmlHelper.getDoc(orig_notification, 'Destination')

      exam_request_id = examSchedulingRequestCreatedEvent['examSchedulingRequestId']
      exam_request_date = examSchedulingRequestCreatedEvent['eventDtg']
      special_considerations = "" # find_special_considerations({xml_doc: exam_request_xml})
      site = get_site(destination_doc)
      system_name = destination_doc['participatingSystemName']
      exam_request_state = ExamRequestState.find_by_code("IN_PROGRESS")

      @exam_request = ExamRequest.create( claim_id: @claim.id,
                                          participating_system_name: system_name,
                                          request_date: exam_request_date,
                                          request_id: exam_request_id,
                                          special_issues: special_considerations,
                                          site_id: site.id.to_s,
                                          identifier: SecureRandom.uuid,
                                          exam_request_state_id: exam_request_state.id)

      process_contentions({orig_notification: orig_notification, claim_id: @claim.id})

      createRequestObject exam_request_xml, @claim.id
      send_emails_to_triage_users site
    end
  end

  def process_reworked_exam_scheduling_request_created_event(exam_request_xml, exam_request_hash)
    puts "Processing"
    ActiveRecord::Base.transaction do
      reworkedExamSchedulingRequestCreatedEvent = exam_request_hash['feed']['entry']['content']['ExamManagementEventNotification']['ReworkedExamSchedulingRequestCreatedEvent']
      claimInformation = reworkedExamSchedulingRequestCreatedEvent['ClaimInformation']

      vbmsClaimId = claimInformation['claimId']
      claimFromDb = Claim.find_by_vbms_claim_id vbmsClaimId

      if claimFromDb.nil?
        raise "Claim with ID: #{vbmsClaimId}, does not exist."
      end

      orig_notification = Nokogiri::XML(exam_request_xml)
      destination_doc = XmlHelper.getDoc(orig_notification, 'Destination')

      reworked_exam_scheduling_request_created_event = XmlHelper.getDoc(orig_notification, 'ReworkedExamSchedulingRequestCreatedEvent')
      exam_related_contentions = XmlHelper.getDoc(reworked_exam_scheduling_request_created_event, 'ExamReworkRelatedContentions')

      exam_related_contentions.elements.each do |contention|
        desc = XmlHelper.getDoc(contention, 'ContentionDescription').text

        exam_related_contention_id = contention['examRelatedContentionId']

        previously_worked_contention_id = contention['previouslyWorkedContentionId']

        @contention = Contention.create(exam_related_contention_id: exam_related_contention_id, claim_id: claimFromDb.id, identifier: SecureRandom.uuid, insufficient: true, previously_worked_contention_id: previously_worked_contention_id)
        ContentionDetail.create(description: desc, name: contention['name'], contention_id: @contention.id, active: true)

        exam_prioritization_special_issues = XmlHelper.getDoc(contention, 'ExamPrioritizationSpecialIssues')
        exam_prioritization_special_issues.elements.each do |special_issue|
          issue = XmlHelper.getDoc(special_issue, 'SpecialIssue').text
          @contention.exam_prioritization_special_issues << ExamPrioritizationSpecialIssue.create(special_issue: issue.to_s)
        end

        rework_reasons = XmlHelper.getAll(contention, 'ReworkReason')
        rework_reasons.each do |rework_reason|
          @contention.rework_reasons << ReworkReason.create(reason: rework_reason.text.strip)
        end

        rework_reason_free_text_list = XmlHelper.getAll(contention, 'ReworkReasonFreetext')
        rework_reason_free_text_list.each do |reason|
          @contention.rework_reason_free_texts << ReworkReasonFreeText.create(reason: reason.text.strip)
        end

        addOrUpdateContentionObject(contention, reworked_exam_scheduling_request_created_event)
      end

      site = get_site(destination_doc)
      create_exam_request exam_request_xml, orig_notification, claimFromDb, site
      #RequestObject processing
      create_reworked_request_object(exam_request_xml, claimFromDb.id)
      send_emails_to_triage_users site
    end
  end

  def processExamSchedulingRequestCancellationEvent(notificationDoc)
    examSchedulingRequestCancellationEvent = XmlHelper.getDoc(notificationDoc, "ExamSchedulingRequestCancellationEvent")
    previousEventId = examSchedulingRequestCancellationEvent['previousEvent']
    examSchedulingRequestId = examSchedulingRequestCancellationEvent['examSchedulingRequestId']
    if (previousEventId.nil? or previousEventId.empty? or examSchedulingRequestId.nil? or examSchedulingRequestId.empty?)
      raise Exception, "Invalid previousEvent"
    end
    if (examSchedulingRequestId.nil? or examSchedulingRequestId.empty?)
      raise Exception, "Invalid examSchedulingRequestId"
    end
    requestObject = getRequestObjectByEventId(previousEventId)
    if (requestObject.nil?)
      raise Exception, "Invalid previousEvent. Unable to locate the ExamRequest record"
    end
    if (validExamRequestCancellationData(previousEventId, examSchedulingRequestId, requestObject))
      examRequest = ExamRequest.find_by_claim_id(requestObject.claim_id)
      if (examRequest.nil?)
        raise Exception, "Unable to locate the ExamRequest record"
      end
      cancelExamRequestExaminations(examRequest)
      cancelExamRequest(notificationDoc, examRequest, requestObject)
      updateRequestObjectWithExamSchedulingRequestCancellationEvent(examSchedulingRequestCancellationEvent, examRequest, requestObject)
    end
  end

  def updateRequestObjectWithExamSchedulingRequestCancellationEvent(examSchedulingRequestCancellationEvent, examRequest, requestObject)
    handleExamSchedulingRequestCancellationEvent(examSchedulingRequestCancellationEvent, examRequest, requestObject)
  end

  def cancelExamRequestExaminations(examRequest)
    @examinations = examRequest.claim.examinations
    if (@examinations != nil && @examinations.count > 0)
      #cancel associated examinations
      cancelledExaminationState = ExaminationState.find_by_code("CANCELLED")
      @examinations.each_with_index do |examination, index|
        examination.examination_state_id = cancelledExaminationState.id
        examination.cancellation_reason = "This examination is cancelled because the parent exam request has been cancelled"
        examination.save

        notes = "This examination is cancelled because the parent exam request has been cancelled"
        @examination_history = ExaminationHistory.new(examination_id: examination.id, notes: notes)
        @examination_history.save

        notes = "Examination "
        notes = notes + "(" + appendContentionNames(examination.contentions) + ") has been cancelled as a result of Exam Request cancellation"
        @@exam_request_history = ExamRequestHistory.new(exam_request_id: examRequest.id, notes: notes)
        @@exam_request_history.save
      end
    end
  end

  def cancelExamRequest(notificationDoc, examRequest, requestObject)
    examRequestState = ExamRequestState.find_by_code("CANCELLED")
    examRequest.exam_request_state_id = examRequestState.id
    examCancellationReason = XmlHelper.getDoc(notificationDoc, "ExamCancellationReason")
    examRequest.cancellation_reason = examCancellationReason.content
    examRequest.save
    notes = "Exam Request has been cancelled"
    @exam_request_history = ExamRequestHistory.new(exam_request_id: examRequest.id, notes: notes)
    @exam_request_history.save
  end

  def validExamRequestCancellationData(previousEventId, examSchedulingRequestIdFromCancellationRequest, requestObject)
    requestObjectDoc = XmlHelper.convertToDocument(requestObject.xml)
    examSchedulingRequest = XmlHelper.getDoc(requestObjectDoc, "ExamSchedulingRequest")
    examSchedulingRequestId = examSchedulingRequest['examSchedulingRequestId']
    if (examSchedulingRequestId != examSchedulingRequestIdFromCancellationRequest)
      raise Exception, "Invalid examSchedulingRequestId. Unable to locate the ExamRequest record"
    end
    return true
  end

  def create_or_update_claim(args = {})
    claim_info = args[:claim_info]
    vet_info = args[:vet_info]
    ssn = args[:ssn]
    vbms_claim_id = args[:vbms_claim_id]

    claim = Claim.find_or_create_by(vbms_claim_id: vbms_claim_id)
    claim.patient_ssn = ssn
    claim.claim_date = claim_info['claimDate']
    claim.label = claim_info['claimLabel']
    claim.end_product_code = claim_info['endProductCode']
    claim.vbms_claim_id = vbms_claim_id
    claim.edipi = vet_info['EDIPI']
    claim.participant_id = vet_info['participantId']
    claim.gender = vet_info['gender']
    claim.vista_ien = vet_info['vistaIen']
    claim.file_number = vet_info['fileNumber']
    claim.first_name = vet_info['firstName']
    claim.middle_name = vet_info['middleName']
    claim.last_name = vet_info['lastName']
    claim.date_of_birth = vet_info['dateOfBirth']
    claim.email = vet_info['emailAddress']
    #claim.phone_number = vet_info.dig('Phone','primaryPhone')
    #claim.alternate_phone = vet_info.dig('Phone','alternatePhone')
    #claim.integration_control_number = vet_info.dig('IntegrationControlNumber','Value')
    claim.poa_vso_name = vet_info['PoaVsoName']
    claim.poa_vso_number = vet_info['PoaVsoNumber']
    #claim.regional_office_id = vet_info.dig('RegionalOffice','stationNumber')
    claim.benefit_type = claim_info['benefitProgramType']

    claim.save
    claim
  end

  def ssn_assignment(args = {})
    ssn = args[:vet_info]['SocialSecurityNumber']['Value']
    ssn.nil? ? "-" : ssn
  end

  def get_site(destination_doc)
    the_destination_system_name = destination_doc['participatingSystemName']
    case the_destination_system_name
      when "VBMS"
        raise "|#{the_destination_system_name}| is not a valid participatingSystemName for a Destination element"
      when 'VBA Contractor'
        contractorName = destination_doc['contractorName']
        siteFromDb = Site.find_by_name(contractorName)
        siteFromDb.nil? ? raise(Exception, "Invalid Contractor ::: #{contractorName}") : siteFromDb
      when "VHA"
        the_vha_site_name = "Boise VA Medical Center"  #cs 2017-07-19 Stopgap until ZIP Code functionality is added
        the_vha_site = Site.find_by_name(the_vha_site_name)
        the_vha_site.nil? ? raise(Exception, "|#{the_vha_site_name}| is not a valid Site") : the_vha_site
      else
        raise "|#{the_destination_system_name}| is not a valid participatingSystemName for a Destination element"
    end
  end

  def create_geo_location(args={})
    claim_id = args[:claim_id]
    vet_info = args[:vet_info_xml]
    xml = vet_info['PreferredGeographicLocation']

    return if vet_info['PreferredGeographicLocation'].nil?
    geo_location = PreferredGeoLocation.find_or_create_by(claim_id: claim_id, zip: xml['ZipCode'])
    geo_location.claim_id = claim_id
    geo_location.address_1 = xml['Address1']
    geo_location.address_2 = xml['Address2']
    geo_location.address_3 = xml['Address3']
    geo_location.city = xml['City']
    geo_location.state = xml['State']
    geo_location.zip = xml['ZipCode']
    geo_location.save
  end

  def create_service_periods(args = {})
    claim_id = args[:claim_id]
    vet_info = args[:vet_info_xml]
    periods = vet_info['PeriodsOfService']['Period']

    return if vet_info['PeriodsOfService']['Period'].nil?
    Array.wrap(periods).each do |period|
      eras = ""
      entry_date = period['entryOnDuty'].to_datetime
      end_date = period['serviceEndDate'].to_datetime
      branch = period['branchOfService']
      period['Eras'].each { |era| eras << "#{era} " } if period['Eras'].present?

      service_period = ServicePeriod.find_or_create_by(claim_id: claim_id, entry_on_duty: entry_date)
      service_period.entry_on_duty = entry_date
      service_period.service_end_date = end_date
      service_period.branch_of_service = branch
      service_period.eras = eras.strip
      service_period.claim_id = claim_id
      service_period.save
    end
  end

  def create_regional_office(args = {})
    vet_info = args[:vet_info_xml]
    xml = vet_info['RegionalOffice']
    station_number = xml['stationNumber']

    if RegionalOffice.find_by_station_number(station_number).nil?
      city = xml['PhysicalAddress']['City']
      state = xml['PhysicalAddress']['State']
      zip = xml['PhysicalAddress']['ZipCode']
      country = xml['PhysicalAddress']['Country']
      m_city = xml['MailingAddress']['City']
      m_state = xml['MailingAddress']['State']
      m_zip = xml['MailingAddress']['ZipCode']
      m_country = xml['MailingAddress']['Country']

      regional_office = RegionalOffice.new
      regional_office.station_number = station_number
      regional_office.physical_address = "#{city} #{state} #{zip} #{country}"
      regional_office.mailing_address = "#{m_city} #{m_state} #{m_zip} #{m_country}"
      regional_office.save
    end
  end

  def find_special_considerations (args={})
    orig_xml = Nokogiri::XML(args[:xml_doc])
    special_xml_element = orig_xml.at('//em:'+'SpecialIssue',
                                      em: 'http://va.gov/vler/schemas/vlerSupersetSchema/examManagement/1.0')

    special_considerations = ""
    return special_considerations if special_xml_element.nil?

    special_xml_element.children.each do |c|
      special_considerations += c.text + ", "
    end

    special_considerations.chomp!(", ")
    special_considerations
  end

  def process_contentions(args={})
    orig_notification = args[:orig_notification]
    claim_id = args[:claim_id]
    exam_request_id = Claim.find(claim_id).exam_request_ids.first

    the_error_string =""

    exam_scheduling_request_created_event = XmlHelper.getDoc(orig_notification, 'ExamSchedulingRequestCreatedEvent')
    exam_related_contentions = XmlHelper.getDoc(exam_scheduling_request_created_event, 'ExamRelatedContentions')

    exam_related_contentions.elements.each do |contention|
      desc = XmlHelper.getDoc(contention, 'ContentionDescription').text
      examRelatedContentionId = contention['examRelatedContentionId']
      contentionFromDb = Contention.find_by_exam_related_contention_id_and_claim_id(examRelatedContentionId, claim_id)
      the_contention_to_use = contentionFromDb
      if contentionFromDb.nil?
        @contention = Contention.create(exam_related_contention_id: examRelatedContentionId,
                                        claim_id: claim_id,
                                        identifier: SecureRandom.uuid,
                                        exam_request_id: exam_request_id)
        ContentionDetail.create(description: desc,
                                name: contention['name'],
                                contention_id: @contention.id,
                                active: true)
        the_contention_to_use = @contention
      end

      the_contention_related_dbq_requests_envelope = XmlHelper.getDoc(contention,'DbqRequests')
      the_contention_related_dbq_requests_envelope.elements.each do |the_current_dbq_request_envelope|
        the_dbq_request_identifier = the_current_dbq_request_envelope['name']
        begin
          the_dbq_information = DbqInformation.find_by!(identifier: the_dbq_request_identifier)
          the_contention_to_use.creates_a_unique_dbq_information_association_with(the_dbq_information)
        rescue Exception => the_exception
          the_error_string += "|#{the_dbq_request_identifier}| is not a valid DbqRequest Identifier\nPlease refer to UC402 Master Copy v7.7 for DBQ Request naming conventions\n"
        end
      end
      if the_error_string.length > 0
        raise the_error_string
      end

      addOrUpdateContentionObject(contention, exam_scheduling_request_created_event)
    end
  end

  def createRequestObject(exam_request_xml, claimId)
    # Get nokogiri doc versions of the request object template and the incoming ExamSchedulingRequest notification0
    template_path = File.join(Rails.root.to_s, 'app', 'xml', 'templates', 'request_object_template.xml')
    req_object_doc = Nokogiri::XML(File.open(template_path))
    orig_notification_doc = Nokogiri::XML(exam_request_xml)

    on_esrce = XmlHelper.getDoc(orig_notification_doc, 'ExamSchedulingRequestCreatedEvent').attributes
    examSchedulingRequest = XmlHelper.getDoc(req_object_doc, 'ExamSchedulingRequest')
    examSchedulingRequest['examSchedulingRequestId'] = on_esrce['examSchedulingRequestId']

    # Copy ClaimInformation Node into requestObject template doc
    ro_claim_info = XmlHelper.getDoc(req_object_doc, 'ClaimInformation')
    on_claim_info = XmlHelper.getDoc(orig_notification_doc, 'ClaimInformation')
    ro_claim_info.replace on_claim_info.clone
    #claimId = on_claim_info.attributes['claimId'].value

    # Copy Contentions Node into requestObject template doc
    ro_contentions = XmlHelper.getDoc(req_object_doc, 'Contentions')
    on_contentions = XmlHelper.getDoc(orig_notification_doc, 'ExamRelatedContentions')
    ro_contentions.replace on_contentions.clone
    XmlHelper.getDoc(req_object_doc, 'ExamRelatedContentions').name = "Contentions"

    # Copy ExamSchedulingRequestCreatedEvent Node into requestObject template doc
    ro_esr_created_event = XmlHelper.getDoc(req_object_doc, 'ExamSchedulingRequestCreatedEvent')
    on_esr_created_event = XmlHelper.getDoc(orig_notification_doc, 'ExamSchedulingRequestCreatedEvent')
    ro_esr_created_event.replace on_esr_created_event.clone

    # Copy EventSource Node into requestObject template doc (there are multiple occurrances in request_object_doc, hence the search().each)
    req_object_doc.search('//em:EventSource').each do |es|
      on_event_source = XmlHelper.getDoc(orig_notification_doc, 'EventSource')
      es.replace on_event_source.clone
    end

    # Copy these values directly
    ro_erae = XmlHelper.getDoc(req_object_doc, 'ExamRequestAcknowledgementEvent').attributes
   # on_esrce = XmlHelper.getDoc(orig_notification_doc, 'ExamSchedulingRequestCreatedEvent').attributes
    ro_erae['examSchedulingRequestId'].value = on_esrce['examSchedulingRequestId']
    ro_erae['eventId'].value = on_esrce['eventId']
    ro_erae['eventDtg'].value = on_esrce['eventDtg']
    ro_erae['modelVersion'].value = on_esrce['modelVersion']
    eventId = ro_erae['eventId'].value

    # Find the most recent requestObject record which matches the claim_id from the incoming request.
    # q
    # If present, set active=false. Then add the new active requestObject record.
    reqObject = RequestObject.all.order('created_at desc').find_by_claim_id claimId
    if reqObject.present?
      reqObject.update(active: false)
      reqObject.save
    end
    reqObject = RequestObject.create(request_type: "ExamSchedulingRequestCreatedEvent_Notification", event_id: eventId, claim_id: claimId, active: true, xml: req_object_doc.to_xml)

    examReq = ExamRequest.find_by_claim_id(claimId)
    examAckNotification = ExamRequestAcknowledgementNotification.new
    eventId = examAckNotification.build_notification(orig_notification_doc, req_object_doc, examReq.site)
    VlerDASJob.sendNotification(examAckNotification, eventId, claimId, "Exam Request Acknowledgement Event Notification")
  end

  def create_reworked_request_object(exam_request_xml, claimId)
    # Get nokogiri doc versions of the request object template and the incoming ExamSchedulingRequest notification0
    template_path = File.join(Rails.root.to_s, 'app', 'xml', 'templates', 'reworked_exam_scheduling_request_object_template.xml')
    req_object_doc = Nokogiri::XML(File.open(template_path))
    orig_notification_doc = Nokogiri::XML(exam_request_xml)

    on_esrce = XmlHelper.getDoc(orig_notification_doc, 'ReworkedExamSchedulingRequestCreatedEvent').attributes
    examSchedulingRequest = XmlHelper.getDoc(req_object_doc, 'ReworkedExamSchedulingRequest')
    examSchedulingRequest['examSchedulingRequestId'] = on_esrce['examSchedulingRequestId'].value

    # Copy ClaimInformation Node into requestObject template doc
    ro_claim_info = XmlHelper.getDoc(req_object_doc, 'ClaimInformation')
    on_claim_info = XmlHelper.getDoc(orig_notification_doc, 'ClaimInformation')
    ro_claim_info.replace on_claim_info.clone
    #claimId = on_claim_info.attributes['claimId'].value

    # Copy Contentions Node into requestObject template doc
    ro_contentions = XmlHelper.getDoc(req_object_doc, 'Contentions')
    on_contentions = XmlHelper.getDoc(orig_notification_doc, 'ExamReworkRelatedContentions')
    ro_contentions.replace on_contentions.clone
    XmlHelper.getDoc(req_object_doc, 'ExamReworkRelatedContentions').name = "Contentions"

    # Copy ExamSchedulingRequestCreatedEvent Node into requestObject template doc
    ro_esr_created_event = XmlHelper.getDoc(req_object_doc, 'ReworkedExamSchedulingRequestCreatedEvent')
    on_esr_created_event = XmlHelper.getDoc(orig_notification_doc, 'ReworkedExamSchedulingRequestCreatedEvent')
    ro_esr_created_event.replace on_esr_created_event.clone

    # Copy EventSource Node into requestObject template doc (there are multiple occurrances in request_object_doc, hence the search().each)
    req_object_doc.search('//em:EventSource').each do |es|
      on_event_source = XmlHelper.getDoc(orig_notification_doc, 'EventSource')
      es.replace on_event_source.clone
    end

    # Copy these values directly
    ro_erae = XmlHelper.getDoc(req_object_doc, 'ExamRequestAcknowledgementEvent').attributes
   # on_esrce = XmlHelper.getDoc(orig_notification_doc, 'ExamSchedulingRequestCreatedEvent').attributes
    ro_erae['examSchedulingRequestId'].value = on_esrce['examSchedulingRequestId']
    ro_erae['eventId'].value = on_esrce['eventId']
    ro_erae['eventDtg'].value = on_esrce['eventDtg']
    ro_erae['modelVersion'].value = on_esrce['modelVersion']
    ro_erae['previousEvent'].value = on_esrce['eventId']
    eventId = ro_erae['eventId'].value

    # Find the most recent requestObject record which matches the claim_id from the incoming request.
    # If present, set active=false. Then add the new active requestObject record.
    reqObject = RequestObject.all.order('created_at desc').find_by_claim_id claimId
    if reqObject.present?
      reqObject.update(active: false)
      reqObject.save
    end
    reqObject = RequestObject.create(request_type: "ReworkedExamSchedulingRequestCreatedEvent_Notification", event_id: eventId, claim_id: claimId, active: true, xml: req_object_doc.to_xml)

    examAckNotification = ExamRequestAcknowledgementNotification.new
    eventId = examAckNotification.build_notification(orig_notification_doc, req_object_doc)
    VlerDASJob.sendNotification(examAckNotification, eventId, claimId, "Reworked Exam Request Acknowledgement Event Notification")
  end

  def prepare_examination_caption(selected_contentions)
    examination_caption = "Examination for:"
    selected_contentions.each_with_index do |contention, index|
      caption_separator = ""
      if index > 0 && index == selected_contentions.length-1
        caption_separator = " and "
      elsif index > 0
        caption_separator = "; "
      else
        caption_separator = " "
      end
      examination_caption = "#{examination_caption}#{caption_separator}#{the_name_and_associated_dbq_titles_string_for(contention)}"
    end

    examination_caption
  end

  def time_select
    options_for_select(['00:00', '00:30', '01:00', '01:30', '02:00',
                        '02:30', '03:00', '03:30', '04:00', '04:30',
                        '05:00', '05:30', '06:00', '06:30', '07:00',
                        '07:30', '08:00', '08:30', '09:00', '09:30',
                        '10:00', '10:30', '11:00', '11:30', '12:00',
                        '12:30', '13:00', '13:30', '14:00', '14:30',
                        '15:00', '15:30', '16:00', '16:30', '17:00',
                        '17:30', '18:00', '18:30', '19:00', '19:30',
                        '20:00', '20:30', '21:00', '21:30', '22:00',
                        '22:30', '23:00', '23:30'])
  end

  private
  def create_exam_request exam_request_xml, orig_notification, claim, site
    exam_request_state = ExamRequestState.find_by_code("IN_PROGRESS")

    if exam_request_state.nil?
      #FIX ME: Dont throw this exception to outside world
      raise Exception, "Invalid Exam Request State Id"
    end
    @exam_request = ExamRequest.create(claim_id: claim.id, site_id: site.id.to_s, identifier: SecureRandom.uuid, exam_request_state_id: exam_request_state.id)
  end

  def send_emails_to_triage_users site
    site_triage_users = User.all.includes(:sites).where(:sites => {name: site.name}).includes(:site_role_sets).where(:site_role_sets => {triage: "true"})
    site_triage_users.try(:each){|st|
      # ExamManagementMailer.exam_scheduling_request_created(st).deliver_now
    }
  end
end
