class VbmsRFactGroupsController < ApplicationController
  before_action :set_vbms_r_fact_group, only: [:show, :edit, :update, :destroy]

  # GET /vbms_r_fact_groups
  # GET /vbms_r_fact_groups.json
  def index
    @vbms_r_fact_groups = VbmsRFactGroup.all
  end

  # GET /vbms_r_fact_groups/1
  # GET /vbms_r_fact_groups/1.json
  def show
  end

  # GET /vbms_r_fact_groups/new
  def new
    @vbms_r_fact_group = VbmsRFactGroup.new
  end

  # GET /vbms_r_fact_groups/1/edit
  def edit
  end

  # POST /vbms_r_fact_groups
  # POST /vbms_r_fact_groups.json
  def create
    @vbms_r_fact_group = VbmsRFactGroup.new(vbms_r_fact_group_params)

    respond_to do |format|
      if @vbms_r_fact_group.save
        format.html { redirect_to @vbms_r_fact_group, notice: 'Vbms r fact group was successfully created.' }
        format.json { render action: 'show', status: :created, location: @vbms_r_fact_group }
      else
        format.html { render action: 'new' }
        format.json { render json: @vbms_r_fact_group.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /vbms_r_fact_groups/1
  # PATCH/PUT /vbms_r_fact_groups/1.json
  def update
    respond_to do |format|
      if @vbms_r_fact_group.update(vbms_r_fact_group_params)
        format.html { redirect_to @vbms_r_fact_group, notice: 'Vbms r fact group was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @vbms_r_fact_group.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /vbms_r_fact_groups/1
  # DELETE /vbms_r_fact_groups/1.json
  def destroy
    @vbms_r_fact_group.destroy
    respond_to do |format|
      format.html { redirect_to vbms_r_fact_groups_url }
      format.json { head :no_content }
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_vbms_r_fact_group
      @vbms_r_fact_group = VbmsRFactGroup.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def vbms_r_fact_group_params
      params.require(:vbms_r_fact_group).permit(:name, :namespace, :fact_block_tag_name, :diagnosis_tag_name, :symptom_tag_name, :document_title)
    end
end
