class UserController < ApplicationController
  skip_before_action :clear_current_site
  check_authorization
  authorize_resource

  def index
    @site = Site.find(params[:site_id])
    @users = @site.users.order(last_name: :asc)
  end

  def show
    @site = Site.find(params[:site_id])
    @user = User.find(params[:id])
    @site_users = @site.users.map{ |u| [u.last_name_first_name, u.id] }
  end

  def new
  end

  def create
  end

  def edit
  end

  def update
    @site = Site.find(params[:site_id])
    params[:user] ? @user = User.find(params[:user][:id]) : @user = User.find(params[:id])
    @site_users = @site.users.map{ |u| [u.last_name_first_name, u.id] }
    if params[:commit] == "Update Roles"
      uroles = params[:user_roles]
      site_roles = @user.get_site_roles(@site)
      uroles && uroles[:admin] ? site_roles.admin = true : site_roles.admin = false
      uroles && uroles[:triage] ? site_roles.triage = true : site_roles.triage = false
      uroles && uroles[:scheduling] ? site_roles.scheduling = true : site_roles.scheduling = false
      uroles && uroles[:clinician] ? site_roles.clinician = true : site_roles.clinician = false
      uroles && uroles[:super_clinician] ? site_roles.super_clinician = true : site_roles.super_clinician = false
      uroles && uroles[:qa] ? site_roles.qa = true : site_roles.qa = false
      site_roles.save
      flash.now[:notice] = "Roles for " + @user.name + " have been successfully updated on this site."
    end
  end

  def destroy
  end

  def site_request
    @site = Site.find(params[:site_id])
    @user = User.find(params[:id])
  end

  def new_site_user
    uroles = params[:user_roles]
    user = User.find params[:id]
    site = Site.find params[:site_id]
    user.add_site(site)
    site_roles = user.get_site_roles(site)
    uroles && uroles[:admin] ? site_roles.admin = true : site_roles.admin = false
    uroles && uroles[:triage] ? site_roles.triage = true : site_roles.triage = false
    uroles && uroles[:scheduling] ? site_roles.scheduling = true : site_roles.scheduling = false
    uroles && uroles[:clinician] ? site_roles.clinician = true : site_roles.clinician = false
    uroles && uroles[:super_clinician] ? site_roles.super_clinician = true : site_roles.super_clinician = false
    uroles && uroles[:qa] ? site_roles.qa = true : site_roles.qa = false
    site_roles.save
    site.remove_requesting_user user
    UserMailer.site_access_response(user, site, site_roles).deliver_now
    Alert.complete_site_request(user.id, current_user, site.id)
    flash[:notice] = user.name + " has been been granted access to " + site.name
    redirect_to site_user_index_path(site)
  end

  def manage_supervisors
    @user = User.find params[:id]
    @site = Site.find params[:site_id]
    if params[:supervisor]
      if params[:supervisor].dig(:id).present?
        sup = User.find(params[:supervisor].dig(:id))
        @user.add_supervising_clinician(sup)
        flash.now[:notice] = "Supervisory Clinician successfully added for " +@user.name+ " on site " + @site.name
      else
        flash.now[:alert] = "Please select a Supervisory Clinician before clicking the 'Add Supervisor' button"
      end
    elsif params[:sup_id]
      removed_sup = User.find(params[:sup_id])
      @user.remove_supervising_clinician(removed_sup)
    end
    @my_supervisor_clinicians = @user.supervisors.includes(:sites).where(:sites => {id: @site.id})
    @site_supervisor_clinicians =  @site.users.includes(:site_role_sets).where(:site_role_sets => {super_clinician: "true"})
    @site_supervisor_clinicians_dropdown_list = @site_supervisor_clinicians.map{ |u| [u.last_name_first_name, u.id] }
  end
end
