class SupportRequestsController < ApplicationController
  #require 'SecureRandom'
  skip_before_filter :authenticate_user_and_handle_cookies, only: [:new, :create]
  before_action :set_support_request, only: [:show, :edit, :update, :destroy]

  # GET /support_requests
  # GET /support_requests.json
  def index
    @support_requests = SupportRequest.all
  end

  # GET /support_requests/1
  # GET /support_requests/1.json
  def show
  end

  # GET /support_requests/new
  def new
    #@support_request = SupportRequest.new
  end

  # GET /support_requests/1/edit
  def edit
  end

  # POST /support_requests
  # POST /support_requests.json
  def create
    @support_request = SupportRequest.new(support_request_params)
    @support_request.ticket_number = SecureRandom.uuid[0..12]

    respond_to do |format|
      if @support_request.save
        flash[:notice] = "Request submitted!"
        format.html { redirect_to new_support_request_path, notice: 'Support request was successfully sent to staff.' }
        format.json { render action: 'show', status: :created, location: @support_request }
        UserMailer.send_support_request_confirmation(@support_request).deliver_now
      else
        format.html { render action: 'new' }
        format.json { render json: @support_request.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /support_requests/1
  # PATCH/PUT /support_requests/1.json
  def update
    respond_to do |format|
      if @support_request.update(support_request_params)
        format.html { redirect_to @support_request, notice: 'Support request was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @support_request.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /support_requests/1
  # DELETE /support_requests/1.json
  def destroy
    @support_request.destroy
    respond_to do |format|
      format.html { redirect_to support_requests_url }
      format.json { head :no_content }
    end
  end


  private

    # Never trust parameters from the scary internet, only allow the white list through.
    def support_request_params
      params.require(:support_request).permit(:first_name,:last_name,
              :customer_email,:customer_phone,:customer_site,
              :customer_organization,:severity,:issue_description, :details)
    end

    # Use callbacks to share common setup or constraints between actions.
    def set_support_request
      @support_request = SupportRequest.find(params[:id])
    end

end
