# basic controller for ID.me SAML passthru and authentication methods;
# not used for SSOI authentication. Using skip_before_filter for passthru and callback methods
# so that Devise authentication can be properly handled.
class SamlController < ApplicationController
  require 'saml_settings'

  skip_before_filter :authenticate_user!, :only => [:temp_sign_in, :callback]

  # Link to redirect the user to our identity provider. This would generate
  # a SAML Authentication Request and then redirect the user to it,
  # which would transfer control to the Identity Provider (or Broker).
  def temp_sign_in
    saml_auth_request = OneLogin::RubySaml::Authrequest.new
    saml_settings = SAML::SettingsService.saml_settings
    redirect_to saml_auth_request.create(saml_settings)
  end

  # Callback that is called by identity provider with SAML assertion
  # containing the user information; would normally be a post with the assertion.
  # Here, we're just establishing a session as a random user.
  def callback
    saml_response = OneLogin::RubySaml::Response.new(params[:SAMLResponse], settings: SAML::SettingsService.saml_settings)
    if saml_response.is_valid?(true)
      uuid = get_uuid_from_response(saml_response)
      Rails.logger.info("Set ID.me session - uuid: #{uuid}")
      user = User.from_idme(saml_response.attributes)
      if user.present?
        Rails.logger.info("User successfully logged in via ID.me callback.  Attributes = #{user.attributes.inspect}")
        sign_in_and_redirect user
      else
        msg = "ID.me user #{saml_response.attributes['email']} does not have a valid CUI system account. " +
              "Contact the system admin for further assistance."
        Rails.logger.error msg
        flash[:alert] = msg
        redirect_to new_user_session_path
      end
    else
      Rails.logger.error "Invalid SAML response.  Errors: #{saml_response.errors.inspect}"
      flash[:alert] = saml_response.errors
      redirect_to new_user_session_path
    end
  end

private

  def get_uuid_from_response(saml_response)
    return saml_response.name_id
  end

end
