class QuestionModifiersController < ApplicationController
  include DataTablePaginator
  before_action :set_question_modifier, only: [:show, :edit, :update, :destroy]

  # GET /question_modifiers
  # GET /question_modifiers.json
  def index
    @question_modifiers = QuestionModifier.all
  end

  # GET /question_modifiers/1
  # GET /question_modifiers/1.json
  def show
    @question_modifier = QuestionModifier.find(params[:id])
    if params[:delete_general_question_id].present?
      q = @question_modifier.general_questions.find_by_id(params[:delete_general_question_id])
      @question_modifier.general_questions.delete(q)
      flash.now[:notice] = "Question successfully removed."
    end
  end

  # GET /question_modifiers/new
  def new
    @question_modifier = QuestionModifier.new
    @general_questions_not_yet_added = GeneralQuestion.all
    params[:general_question_id].present? ? @general_question = GeneralQuestion.find(params[:general_question_id]) : false

  end

  # GET /question_modifiers/1/edit
  def edit
    @identifier = "TEMP_IDENTIFIER_VALUE"
    if params[:delete_general_question_id].present?
      q = @question_modifier.general_questions.find_by_id(params[:delete_general_question_id])
      @question_modifier.general_questions.delete(q)
      flash.now[:notice] = "Question successfully removed."
    elsif params[:delete_list_value_index].present?
      lindex = params[:delete_list_value_index].to_i
      @question_modifier.list_values.delete_at(lindex)
      @question_modifier.save
      flash.now[:notice] = "List value removed."
    end

    set_general_question_not_yet_added @question_modifier
    @generated_html = @question_modifier.build_html("QUESTION_NAME", @identifier)
  end

  def generated_html
    @question_modifier = QuestionModifier.find(params[:question_modifier_id])
    @generated_html = @question_modifier.build_html("QUESTION_NAME", "TEMP_IDENTIFIER_VALUE")
    render partial: 'evaluation_templates/displayed_result'
  end

  # POST /question_modifiers
  # POST /question_modifiers.json
  def create
    @question_modifier = QuestionModifier.new(question_modifier_params)
    @question_modifier.list_values = question_modifier_params[:list_values].split("\n").map(&:strip)
    respond_to do |format|
      if @question_modifier.save
        format.html {
          if params[:general_question_id].present?
            @general_question = GeneralQuestion.find(params[:general_question_id])
            @general_question.question_modifiers << @question_modifier
          end
          if params[:question_modifier][:prev_url]
            redirect_to params[:question_modifier][:prev_url], notice: 'Question modifier was successfully created.'
          else
            redirect_to @question_modifier, notice: 'Question modifier was successfully created.'
          end
        }
        format.json { render action: 'show', status: :created, location: @question_modifier }
      else
        format.html { render action: 'new' }
        format.json { render json: @question_modifier.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /question_modifiers/1
  # PATCH/PUT /question_modifiers/1.json
  def update
    if params[:identifier].present?
      redirect_to edit_question_modifier_path(@question_modifier, :identifier => params[:identifier])
    else
      respond_to do |format|
        list_values = @question_modifier.list_values.clone
        orig_qm_name = @question_modifier.name
        if @question_modifier.update(question_modifier_params)
          if question_modifier_params[:list_values]
            question_modifier_params[:list_values].split("\n").map(&:strip).each do |v|
              list_values << v
            end
          end
          if params[:question_modifier] && params[:question_modifier][:general_question_ids]
            params[:question_modifier][:general_question_ids].each do |d|
              general_question = GeneralQuestion.find_by_id(d)
              if general_question
                @question_modifier.general_questions << general_question
              end
            end
          end
          @question_modifier.list_values = list_values
          @question_modifier.save
          @question_modifier.update_qma_names if orig_qm_name != @question_modifier.name
          format.html { redirect_to edit_question_modifier_path(@question_modifier), notice: 'Question modifier was successfully updated.' }
          format.json { head :no_content }
        else
          format.html {
            @general_questions_not_yet_added = GeneralQuestion.all
            render action: 'edit'
          }
          format.json { render json: @question_modifier.errors, status: :unprocessable_entity }
        end
      end
    end
  end

  # DELETE /question_modifiers/1
  # DELETE /question_modifiers/1.json
  def destroy
    @question_modifier.destroy
    respond_to do |format|
      format.html { redirect_to question_modifiers_url }
      format.json { head :no_content }
    end
  end

  def paged_list
    question_modifiers_to_fields_func = -> (qm) do
      {
        id:                 qm.id,
        name:               qm.name.try(:humanize),
        row_label:          qm.label.try(:humanize),
        mod_type:           qm.mod_type.try(:humanize),
        list_values:        qm.list_values,
        edit:               edit_question_modifier_path(qm),
        destroy:            question_modifier_path(qm)
      }
    end
    ordered_question_modifiers =  apply_ordering_to_query(QuestionModifier.filter(params), QuestionModifier::FIELDS_FOR_RESULTSET, params['order'])
    return_data = datatables_json_for_query_using_func(
      ordered_question_modifiers, question_modifiers_to_fields_func
    )
    puts "return data: "
    puts return_data.inspect
    render json: return_data
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_question_modifier
      @question_modifier = QuestionModifier.find(params[:id])
    end

    def set_general_question_not_yet_added question_modifier
      @gq_not_yet_added = GeneralQuestion.all.order(name: :ASC)
      question_modifier.general_questions.each do |q|
        @gq_not_yet_added = @gq_not_yet_added.reject{|gq| gq == q}
      end
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def question_modifier_params
      params.require(:question_modifier).permit(:name, :mod_type, :list_values)
    end

end
