class BoilerplateMessagesController < ApplicationController
	include DataTablePaginator
	before_action :set_boilerplate, only: [:edit, :update, :destroy, :sort]

	def index
    boilerplate_message_func = -> (message) do
    	{
        id:                       message.id,
        name:                     message.name,
        content:                	message.content,
        edit:                     edit_boilerplate_message_path(message),
        destroy:                  boilerplate_message_path(message)
      }
    end

    ordered_bpm = BoilerplateMessage.all.order('name asc')
    @return_data = datatables_json_for_query_using_func(
      	ordered_bpm, boilerplate_message_func
    	).to_json
	end

	def show

	end

	def edit
    if params[:delete_dbq_information_id].present?
      min = @boilerplate_message.dbq_informations.find_by_id(params[:delete_dbq_information_id])
      @boilerplate_message.dbq_informations = @boilerplate_message.dbq_informations.reject{|m| m == min}
      flash.now[:notice] = "DBQ Information successfully removed."
    end
    set_boilerplate_messages_not_added @boilerplate_message
	end

	def update
		 respond_to do |format|
      if @boilerplate_message.update(boilerplate_message_params)
        if params[:boilerplate_message] && params[:boilerplate_message][:dbq_information_ids]
          params[:boilerplate_message][:dbq_information_ids].reject(&:empty?).each do |id|
            dbq_information = DbqInformation.find_by_id(id)
            if dbq_information
              @boilerplate_message.dbq_informations << dbq_information
            end
          end
        end
        @boilerplate_message.save
        format.html { redirect_to edit_boilerplate_message_path(@boilerplate_message), notice: 'Boilerplate Message successfully updated.' }
        format.json { head :no_content }
      else
        #set_minor_systems_not_yet_added @boilerplate_message
        #@generated_html = @major_system.build_html
        format.html { render action: 'edit' }
        format.json { render json: @boilerplate_message.errors, status: :unprocessable_entity }
      end
    end

	end

	def destroy
		@boilerplate_message.destroy
    respond_to do |format|
      format.html { redirect_to boilerplate_message_url }
      format.json { head :no_content }
    end
	end

	def new
		@boilerplate_message = BoilerplateMessage.new
	end

	def create
		@boilerplate_message = BoilerplateMessage.new(boilerplate_message_params)

    respond_to do |format|
      if @boilerplate_message.save
        format.html { redirect_to edit_boilerplate_message_path(@boilerplate_message), notice: 'Boilerplate Message was successfully created.' }
      else
        format.html { render action: 'new', notice: 'Issue saving Boilerplate Message.' }
      end
    end
	end

	def sort
    params[:dbq_information].each_with_index do |id, index|
      @boilerplate_message.boilerplate_messages_dbq_informations
      	.where(dbq_information_id: id)
      	.update_all({position: index+1})
    end
    render nothing: true
  end

  private
	def set_boilerplate
		@boilerplate_message = BoilerplateMessage.find(params[:id])
	end

	def boilerplate_message_params
    params.require(:boilerplate_message).permit(:name, :content, :dbq_information_ids)
  end

	def set_boilerplate_messages_not_added message
	  @dbq_info_not_yet_added = DbqInformation.all.order("title ASC")
    message.dbq_informations.each do |ms|
      @dbq_info_not_yet_added = @dbq_info_not_yet_added.reject{|m| m == ms}
    end
  end

end

