// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

function person_jqdr() {
  var userType = $('#usersTable').data('usertype');
  var selectedSite = $('#usersTable').data('site-id');

  /* fake enum used for switch statement -- values must match data-usertype
   * attributes in rendered tables. */
  var tableTypes = {
    CPP_USERS: 'cpp',
    CUI_USERS: 'cui_all',
    CUI_USERS_BY_SITE: 'cui_by_site'
  };

  /* get headers (title and data field binding) required by DataTables.
   * Header titles must match <thead> header names rendered in table.
   * Header data field names must match data from in Ajax JSON response.
   * ajaxRequestData contains a list of query param key/values that will
   *   be appended to the Ajax request sent by DataTables. */
  function getHeadersAndData() {
    var ajaxRequestData = {usertype: userType};
    var headers = [{
      title: "Name",
      data: "last_name_first_name",
      render: function( data, type, row ) {
          return '<a href="/user/' + row.id + '" >' + row.last_name_first_name + '</a>';
      }
    }];
    switch(userType) {
      case tableTypes.CPP_USERS:
        headers.push({title: "Role", data: "human_cpp_rolename"});
        headers.push({title: "Providers", data: "npi_list"});
        break;
      case tableTypes.CUI_USERS:
        headers.push({title: "Sites with Access", data: "list_sites"});
        break;
      case tableTypes.CUI_USERS_BY_SITE:
        ajaxRequestData.siteid = selectedSite;
        headers.push({title: "Roles", data: "roles"});
        break;
    }
    return {
      headers: headers,
      ajaxRequestData: ajaxRequestData
    };
  }

  var headersAndData = getHeadersAndData();

  var usersTable = $('#usersTable').DataTable({
      columns: headersAndData.headers,
      ajax: {
        url: '/user/paged_list',
        data: function(d) {
          return $.extend({}, d, headersAndData.ajaxRequestData);
        }
      },
      processing: true,
      serverSide: true,
      bLengthChange: false,
      bSort: false,
      bFilter: false,
      searching: false,
      pageLength: 10
  });
}
