// Used to populate Facilities based on the selection of Visn
// and Providers based on Facility
// in the drop downs in /Consultations and /Referrals
$(document).ready(function() {

  // Event handler bound to VISN dropdown -- used to load Facility
  // and Provider dropdowns
  $('#visn_id_select').change(function() {
    var option_value_selected = $('#visn_id_select').val();

    if (option_value_selected == "") {
      // Clear Provider dropdown if it exists in filter panel
      if ($('select#provider_id_select').length > 0) {
        $("select#provider_id_select option").remove();
        var row = "<option value=\"" + "" + "\">" + 'All' + "</option>";
        $(row).appendTo("select#provider_id_select");
      }
      // Clear Facility dropdown in filter panel
      $("select#facility_id_select option").remove();
      var row = "<option value=\"" + "" + "\">" + 'All' + "</option>";
      $(row).appendTo("select#facility_id_select");
    }
    else {
      $.ajax({
        type: "POST",
        url: "http://"+location.host+"/get_facilities/"+option_value_selected,
        success: function(data) {
          // Populate Facility dropdown in filter panel
          $("select#facility_id_select option").remove();
          var row = "<option value=\"" + "" + "\">" + 'All' + "</option>";
          $(row).appendTo("select#facility_id_select");
          $.each(data, function(i, j){
            row = "<option value=\"" + j.id + "\">" + j.name + "</option>";
            $(row).appendTo("select#facility_id_select");
          });

          // Populate Provider dropdown if it exists in filter panel
          if ($('select#provider_id_select').length > 0) {
            $.ajax({
              type: "POST",
              url: "http://"+location.host+"/get_providers_without_facility/"+option_value_selected,
              success: function(providerData){
                $("select#provider_id_select option").remove();
                var row = "<option value=\"" + "" + "\">" + 'All' + "</option>";
                $(row).appendTo("select#provider_id_select");
                $.each(providerData, function(i, j){
                  row = "<option value=\"" + j.id + "\">" + j.name + "</option>";
                  $(row).appendTo("select#provider_id_select");
                });
              },
            }); // inner $.ajax()
          }

        }
      }); // outer $.ajax()
    } // if/else (option_value_selected == "")
  }); // $('#visn_id_select').change()

  // Event handler bound to Facility dropdown -- used to load Provider dropdown.
  // Only bind handler if Provider dropdown exists in form.
  if ($('select#provider_id_select').length > 0) {

    $('#facility_id_select').change(function() {
      var data = $('#facility_id_select').val();
      if (data == "") {
        // SMELL: 'data' in parent scope is no longer visible.
        // Using the same variable name in different visible scopes is not good practice.
        var data = $('#visn_id_select').val();

        // Load providers based on selected VISN
        $.ajax({
          type: "POST",
          url: "http://"+location.host+"/get_providers_without_facility/"+data,
          success: function(data) {
            $("select#provider_id_select option").remove();
            var row = "<option value=\"" + "" + "\">" + 'All' + "</option>";
            $(row).appendTo("select#provider_id_select");
            $.each(data, function(i, j){
              row = "<option value=\"" + j.id + "\">" + j.name + "</option>";
              $(row).appendTo("select#provider_id_select");
            });
          }
        }); // $.ajax()
      }
      else {
        // Load providers based on selected facility
        $.ajax({
          type: "POST",
          url: "http://"+location.host+"/get_providers/"+data,
          success: function(data) {
            $("select#provider_id_select option").remove();
            var row = "<option value=\"" + "" + "\">" + 'All' + "</option>";
            $(row).appendTo("select#provider_id_select");
            $.each(data, function(i, j){
              row = "<option value=\"" + j.id + "\">" + j.name + "</option>";
              $(row).appendTo("select#provider_id_select");
            });
          },
        }); // $.ajax()

      }
    }); // $('#facility_id_select').change()

  } // '#provider_id_select' exists in form

});
