// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

function consultations_jqdr() {
  /* get headers (title and data field binding) required by DataTables.
   * Header titles must match <thead> header names rendered in table.
   * Header data field names must match data from in Ajax JSON response. */
  function getHeaders() {
      return [
        {title: "Name", data: "patient_name", orderable: true},
        {title: "SSN", data: "ssn", orderable: true},
        {title: "Episode of Care", data: "episode_of_care", orderable: true},
        {title: "Status", data: "status", orderable: true},
        {title: "Ordering Physician", data: "ordering_physician", orderable: false},
        {title: "Date", data: "date", orderable: true}
    ];
  }

  var $table = $('#consultationList').DataTable({
    columns: getHeaders(),
    ajax: '/consultations/paged_list',
    processing: true,
    serverSide: true,
    bLengthChange: false,
    bSort: true,
    bFilter: false,
    searching: false,
    pageLength: 10
  });

  var AUTOCOMPLETE_MIN_LENGTH = 2;

  // Handles autocomplete functionality for Ordering Provider textbox
  $('form#consultationFilterForm #ordering_provider_text').autocomplete({
    source: function(request, response) {
      var facility_id = $("#facility_id_select").val();
      var visn_id = $("#visn_id_select").val();
      if ((facility_id === '') && (visn_id === '')) {
        $('#physicianSearchErrorMsg').show();
      }
      else {
        $('#physicianSearchErrorMsg').hide();
        $.ajax({
          url: '/consultations/physician_select',
          dataType: 'json',
          data: {
             term: request.term,
             facility_id: $("#facility_id_select").val(),
             visn_id: $("#visn_id_select").val()
          }
        }).done(function(data) {
          // invoke response callback to load dropdown list, with names only
          var dropdownData = $.map(data, function(val) {
            return {label: val.name, value: val.id};
          });
          response(dropdownData);
        });
      }
    },
    select: function(event, ui) {
      event.preventDefault();
      $('form#consultationFilterForm #ordering_provider_text').val(ui.item.label);
      $('form#consultationFilterForm #ordering_provider_id').val(ui.item.value);
    },
    minLength: AUTOCOMPLETE_MIN_LENGTH,
    delay: 200
  });

  $('form#consultationFilterForm #ordering_provider_text').on('change', function() {
    if ($(this).val().length < AUTOCOMPLETE_MIN_LENGTH) {
      $('form#consultationFilterForm #ordering_provider_id').val('');
    }
  });

  // add event handler for when user clicks on datatable row
  $('#consultationList tbody').on('click', 'tr', function () {
    var data = $table.row(this).data();
    if (!isNaN(parseInt(data.id))) {
      window.location = "consultations/" + parseInt(data.id);
    }
  });

  $('.date-field').datepicker();

  // Triggered when user changes NPI field
  $('.consultation-npi').change(function() {
    var npi = $(this).val();
    if (npi === '') {
      $.each($('input[data-fieldname]'), function(k, inputVal) {
        $(inputVal).prop('readonly', false).val('');
      });
    }
    else {
      $.getJSON('/providers/find_by_npi/' + npi)
        .done(function(data) {
          $.each($('input[data-fieldname]'), function(k, inputVal) {
            var fieldName = $(inputVal).data('fieldname');
            $(inputVal).prop('readonly', true).val(data[fieldName]);
          });
        })
        .fail(function(jqXHR) {
          $('#invalid-ssn').remove();
          $('#header').after('<div class="alerts alert-box alert animated fadeIn" id="invalid-ssn"> <div class="row"> <div class="small-12 columns">' +
            (jqXHR.responseJSON.error || 'Invalid NPI value.') + '</div> </div> </div>');
          window.scrollTo(0,0);
        });
    }
  });

  $(document).on("keypress", "form.new_consultation", function(event) {
      return event.keyCode != 13;
  });

  $(document).on('click', 'button#resetConsultFilterButton', function(e) {
    // perform form reset, then reset hidden form inputs separately.
    // (Hidden inputs don't reset as per W3C standards.)
    var $formElement = $('#consultationFilterForm');
    $formElement[0].reset();
    $formElement.find('input:hidden').val('');
    $('#toDateAndFromDateError').hide();
    $("select#facility_id_select option").remove();
    $("select#physician_id_select option").remove();
    var row = "<option value=\"" + "" + "\">" + 'All' + "</option>";
    $(row).appendTo("select#facility_id_select");
    $(row).appendTo("select#physician_id_select");
    $.get('/reset_filter', function(data) {
      if (data.success) {
        $table.draw();
      }
      else {
        alert('Error clearing Consultation filtering preferences.  Consult the Help Desk for support.');
      }
    });
  });

  /* handle Filter button form action on top panel */
  $("form#consultationFilterForm").submit(function(e) {
    $.ajax({
      type: "POST",
      url: $(this).attr('action'),
      data: $(this).serialize() // serializes the form's elements.
    })
    .done(function(data) {
      if (data.success) {
        $table.draw();
      }
      else {
        alert('Error settting Consultation filtering preferences.  Consult the Help Desk for support.');
      }
    });
    e.preventDefault(); // avoid to execute the actual submit of the form.
  });

  autopopulate_consultation();

  //modal-popup for mpi lookup ssn serach and datatable
  $(document).on('click', 'button#addConsult', function(e) {
    $('#add_consult_modal').show();
  });

  $('#close_add_consult_modal').click(function() {
    $('#add_consult_modal').hide();
  });

  $("#add_consult_modal").mouseup(function(e)
    {
        var subject = $(".modal-content");

        if(e.target.id != subject.attr('id') && !subject.has(e.target).length)
        {
            $("#add_consult_modal").fadeOut();
        }
    });

  $(document).on('click', 'button#mpi-button', function(e) {
    var ssn = $('#mpi-ssn').val();
      $.ajax({
        type: "GET",
        url: '/consultations/get_patient_consult_details?ssn='+ssn,
      })
      .done(function(data) {
        $('#viaConsultDetails').dataTable().fnDestroy();

        if (data.status == 'ok') {
          $('.no_via_consults').hide();
          $('.via_consults_datatable').show();
          $('#viaConsultDetails').DataTable({
            "aaData": data.data,
            "aoColumns": [
            { "mDataProp": "last_name"},
            { "mDataProp": "first_name" },
            { "mDataProp": "middle_name"},
            { "mDataProp": "date_of_birth"},
            { "mDataProp": "city"},
            { "mDataProp": "zip"},
            { "mDataProp": "id"},
            { "mDataProp": "timestamp"}],
            "pageLength": 3,
            "bLengthChange": false,
            "bSort": true,
            "searching": false
          });
        }
      }).fail(function(resp) {
        $('p#no_via_consults').text(resp.responseJSON["error"][0]);
        $('.no_via_consults').show();
        $('.via_consults_datatable').hide();
      });
      e.preventDefault(); // avoid to execute the actual submit of the form.
  });

  $(document).on('click', '#viaConsultDetails tbody tr', function(e) {
    v = $('#viaConsultDetails').DataTable().row(this).data();
    window.location = "consultations/new?first_name=" + v.first_name +
                        "&middle_name=" + v.middle_name +
                        "&last_name=" + v.last_name +
                        "&consult_id=" + v.id +
                        "&consult_name=" + v.title +
                        "&dob=" + v.date_of_birth +
                        "&ssn=" + v.ssn +
                        "&mpi_pid=" + v.mpi_pid +
                        "&local_pid=" + v.local_pid +
                        "&consult_created_at=" + v.timestamp +
                        "&consult_text=" + v.text +
                        "&other_health_insurance_name=" + escape(v.other_health_insurance_name);
  });

  consultation_text_minify();

};

function autopopulate_consultation(){
  try {
    $('#from_date').val($('#from_date').data('source'));
    $('#to_date').val($('#to_date').data('source'));
    $('#first_name').val($('#first_name').data('source'));
    $('#last_name').val($('#last_name').data('source'));
    $('#ssn').val($('#ssn').data('source'));
    $('#mpi_pid').val($('#mpi_pid').data('source'));
    $('#local_pid').val($('#local_pid').data('source'));
    $('#coordinator_id').val($('#coordinator_id').data('source'));
    $('#care_category_id').val($('#care_category_id').data('source'));
    $('#consultation_number').val($('#consultation_number').data('source'));
    $('#authorization_number').val($('#authorization_number').data('source'));
    $('#visn_id_select').val($('#visn_id_select').data('source'));
    $("#ordering_provider_text").val($('#ordering_provider_text').data('source'));
    $("#ordering_provider_id").val($('#ordering_provider_id').data('source'));

    try {
      var selected_checkboxes = $("input[name='status[]']").data('source')
      var checkboxes = $("input[name='status[]']");
      checkboxes.each(function(_, element){
        if(selected_checkboxes != undefined && selected_checkboxes.includes(element.value)) {
          element.checked = true;
        }
      });
     }catch(e){
      console.log("Error occurred while populating status values :" + e)
     }
  }
  catch(e){
    console.log("Error occurred while populating the session data in form : " + e)
  }
}

function consultation_text_minify(){
  var minimized_elements = $('span.consultation_text');

    minimized_elements.each(function(){
        var t = $(this).text();
        if(t.length < 400) return;
        $(this).html(
            t.slice(0,400)+'<a href="#" class="more">Show More...</a>'+
            '<span style="display:none;">'+ t.slice(400,t.length)+' <a href="#" class="less">Show Less...</a></span>'
        );
    });
    $('a.more', minimized_elements).click(function(event){
        event.preventDefault();
        $(this).hide().prev().hide();
        $(this).next().show();
        $('#consultation_text').css('overflowY', 'scroll');
    });
    $('a.less', minimized_elements).click(function(event){
        event.preventDefault();
        $(this).parent().hide().prev().show().prev().show();
    });
}
