// This is a manifest file that'll be compiled into application.js, which will include all the files
// listed below.
//
// Any JavaScript/Coffee file within this directory, lib/assets/javascripts, vendor/assets/javascripts,
// or vendor/assets/javascripts of plugins, if any, can be referenced here using a relative path.
//
// It's not advisable to add code directly here, but if you do, it'll appear at the bottom of the
// compiled file.
//
// Read Sprockets README (https://github.com/sstephenson/sprockets#sprockets-directives) for details
// about supported directives.
//
//= require jquery3
//= require jquery_ujs
//= require dataTables/jquery.dataTables
//= require jquery-ui
//= require jquery-ui/widgets/datepicker
//= require jquery-ui/widgets/autocomplete
//= require datetimepicker
//= require moment
//= require jquery.mask
//= require jquery-validator
//= require jquery-ui/widgets/sortable
//= require chosen
//= require foundation
//= require js.cookie
//= require jstz
//= require browser_timezone_rails/set_time_zone
//= require_tree .

//JQuery 3 fix. Allows "load" to work in gems that require it.
jQuery.fn.load = function(callback){
   $(window).on("load", callback)
};

$(function(){
  // Commented out the code below since the chosen() functionality
  // attached to these controls renders them out of compliance with 508
  // (The controls don't function properly at this time when a screen reader
  // running.  Thus we can't use this capability.)
  // note: 10/12/16 - john mcmanamon- reactivated the chosen functionalty
  // for the evaluation spec control below per user request.
  // This is temporary until a workaround can be found.
  $("#evaluation_evaluation_spec_id").chosen();
  $("#support_request_customer_site").chosen();
  //$("#user_id").chosen();
  //$("#site_select_id").chosen();
  //$("#site_selection_id").chosen();
  //$("#my_site_select_id").chosen();
  //$("#all_site_select_id").chosen();
  //
  function setDatepicker(id) {
    $(id).datepicker({
      selectOtherMonths: true,
      changeMonth: true,
      changeYear: true
    });
  }
  // 508 helper method that outputs message into a span
  // checks for a ctrl or cmd keypress plus arrow keys
  $('#examination_date').keydown(function(e) {
    var modifier = e.ctrlKey || e.metaKey
    if (modifier && e.keyCode >= 37 && e.keyCode <= 40) {
      var message = "" + $(".ui-state-hover").html() +
        " " + $(".ui-datepicker-month").html() +
        " " + $(".ui-datepicker-year").html();
      $('#liveRegion').html(message);
    }
  });

  setDatepicker("#examination_date");
  $("#veteran_birth_date").datepicker({
        selectOtherMonths: true,
        changeMonth: true,
        changeYear: true,
        defaultDate: new Date(1950,1)
      });
  setDatepicker("#elapsed_days");
  setDatepicker("#exam_request_start_date");
  setDatepicker("#exam_request_end_date");
  setDatepicker("#dates_");
  setDatepicker("#dates_e");

  $('#table_id').DataTable({
    "language": {
      "lengthMenu": "Display _MENU_ Records",
      "zeroRecords": "No records found",
      "info": "Showing page _PAGE_ of _PAGES_",
      "infoEmpty": "No records available",
      "infoFiltered": "(filtered from _MAX_ total records)"
    }
  });

  $('#ssn, #veteran_ssn').on('keydown keypress input blur', function(){
    if($(this).val() && $(this).val().length > 4){
       $(this).mask("000-00-0000");
    }else {
       $(this).unmask();
    }
  });

  $(".consultation-phone").mask("000-000-0000");

  // foundation has to be at the bottom of this function for some reason
  // it creates an issue with datepicker jquery
  $(document).foundation();
});


// ===== Scroll to Top ====
// The below code is added for 'Return to top' functionallty
$(window).scroll(function() {
  if ($(this).scrollTop() >= 50) {        // If page is scrolled more than 50px
      $('#return-to-top').fadeIn(200);    // Fade in the arrow
  } else {
      $('#return-to-top').fadeOut(200);   // Else fade out the arrow
  }
});

$('#return-to-top').click(function() {      // When arrow is clicked
  $('body,html').animate({
     scrollTop : 0                       // Scroll to top of body
   }, 500);

});

function pingServer() {
  // keep the server from timing out - called from application.html.haml
  $.ajax({
    type: "GET",
    url: "/pingserver",
    data: "",
    dataType: "",
   });
   // call again in 20 mins
   setTimeout(pingServer, 20*60*1000);
}

/* Feedback Form Alert Box */
function feedbackalert(){
  var feedbackalert = localStorage.getItem('feedbackalert') || '';
  if (feedbackalert != 'yes') {
   alert("Caution: Do not include any sensitive or classified information in feedback");
   localStorage.setItem('feedbackalert','yes');
  }
  $(window).on('beforeunload', function() {
    localStorage.setItem('feedbackalert','');
  });
}

