require 'rails_helper'

RSpec.describe "general_questions/index", :type => :view do
  before(:each) do
    assign(:general_questions, [
      GeneralQuestion.create!(
        :name => "Name",
        :label => "Label",
        :diagnosis_modifier_id => 1,
        :minor_system_id => 2
      ),
      GeneralQuestion.create!(
        :name => "Name",
        :label => "Label",
        :diagnosis_modifier_id => 1,
        :minor_system_id => 2
      )
    ])
  end

  it "renders a list of general_questions" do
    render
    assert_select "tr>td", :text => "Name".to_s, :count => 2
    assert_select "tr>td", :text => "Label".to_s, :count => 2
    assert_select "tr>td", :text => 1.to_s, :count => 2
    assert_select "tr>td", :text => 2.to_s, :count => 2
  end
end
