require 'rails_helper'

RSpec.describe "examination_notes/index", :type => :view do
  before(:each) do
    assign(:examination_notes, [
      ExaminationNote.create!(
        :from_id => 1,
        :to_id => 2,
        :note => "MyText",
        :type => "Type"
      ),
      ExaminationNote.create!(
        :from_id => 1,
        :to_id => 2,
        :note => "MyText",
        :type => "Type"
      )
    ])
  end

  it "renders a list of examination_notes" do
    render
    assert_select "tr>td", :text => 1.to_s, :count => 2
    assert_select "tr>td", :text => 2.to_s, :count => 2
    assert_select "tr>td", :text => "MyText".to_s, :count => 2
    assert_select "tr>td", :text => "Type".to_s, :count => 2
  end
end
