require 'rails_helper'

RSpec.describe "diagnosis_modifiers/index", :type => :view do
  before(:each) do
    assign(:diagnosis_modifiers, [
      DiagnosisModifier.create!(
        :name => "Name",
        :label => "Label",
        :mod_type => "Mod Type",
        :list_values => "List Values",
        :html => "MyText"
      ),
      DiagnosisModifier.create!(
        :name => "Name",
        :label => "Label",
        :mod_type => "Mod Type",
        :list_values => "List Values",
        :html => "MyText"
      )
    ])
  end

  it "renders a list of diagnosis_modifiers" do
    render
    assert_select "tr>td", :text => "Name".to_s, :count => 2
    assert_select "tr>td", :text => "Label".to_s, :count => 2
    assert_select "tr>td", :text => "Mod Type".to_s, :count => 2
    assert_select "tr>td", :text => "List Values".to_s, :count => 2
    assert_select "tr>td", :text => "MyText".to_s, :count => 2
  end
end
