require 'rails_helper'

RSpec.describe "alerts/edit", :type => :view do
  before(:each) do
    @alert = assign(:alert, Alert.create!(
      :user_id => 1,
      :description => "MyText",
      :active => ""
    ))
  end

  it "renders the edit alert form" do
    render

    assert_select "form[action=?][method=?]", alert_path(@alert), "post" do

      assert_select "input#alert_user_id[name=?]", "alert[user_id]"

      assert_select "textarea#alert_description[name=?]", "alert[description]"

      assert_select "input#alert_active[name=?]", "alert[active]"
    end
  end
end
