require 'rails_helper'
require 'rake'

DrTurboTax::Application.load_tasks

describe "copy existing exam request data to claims" do
  before do
    @hello_world_exam_request = create(:hello_world_exam_request)
    @hola_world_exam_request = create(:hola_world_exam_request)
    @claim_without_exam_request_data = create(:claim_without_exam_request_data)
    @claim_with_exam_request_data = create(:claim)

  end

  it "should not modify a claim if that claim is not referenced by an exam_request.claim_id." do
    #The rake task exam_requests:copy_existing_data_to_claims may have already been invoked in another example, so reenable it.
    Rake::Task['exam_requests:copy_existing_data_to_claims'].reenable
    Rake::Task['exam_requests:copy_existing_data_to_claims'].invoke 
    expect(ExamRequest.where.not(claim_id:  nil).size).to eq 0
    #Note that @claim_<...> holds data from before the rake task, thus we look into the table for the updates.
    expect(Claim.first.exam_request_data).to eq  @claim_without_exam_request_data.exam_request_data
    expect(Claim.last.exam_request_data).to eq   @claim_with_exam_request_data.exam_request_data
  end

  it "should copy existing exam request data to the reference claim if that claim does not have exam_request_data" do
    @hello_world_exam_request.update_attributes(claim_id: @claim_without_exam_request_data.id)
    #The rake task exam_requests:copy_existing_data_to_claims may have already been invoked in another example, so reenable it.
    Rake::Task['exam_requests:copy_existing_data_to_claims'].reenable
    Rake::Task['exam_requests:copy_existing_data_to_claims'].invoke 
    #Note that @claim_<...> holds data from before the rake task, thus we need to look into the table for the updates.
    expect(Claim.first.exam_request_data).to eq  Hash.from_xml(@hello_world_exam_request.xml)
  end

  it "should not copy existing exam request data if the referenced claim already has exam_request_data" do
    @hello_world_exam_request.update_attributes(claim_id: @claim_with_exam_request_data.id)
    expect(@claim_with_exam_request_data.exam_request_data).to match({"ExamRequest" => "Hi. I am exam request data"})
    #The rake task exam_requests:copy_existing_data_to_claims may have already been invoked in another example, so reenable it.
    Rake::Task['exam_requests:copy_existing_data_to_claims'].reenable
    Rake::Task['exam_requests:copy_existing_data_to_claims'].invoke 
    #Note that @claim_<...> holds data from before the rake task, thus we need to look into the table for the updates.
    expect(Claim.last.exam_request_data).to match({"ExamRequest" => "Hi. I am exam request data"})
  end


end


