require 'rails_helper'

require 'via_api.rb'

RSpec.describe 'VIA_API::SchedulingService', cpp: true do

  before do
    WebMock.enable!
    login_via_response = Rails.root.join("spec/support/via_api/login_via_response.xml").read
    get_clinics_response = Rails.root.join("spec/support/via_api/get_clinics_with_specialties_response.xml").read
    url  = VIA_API::VIA_SCHEDULING_ENDPOINT_URL
    login_url = VIA_API::VIA_EMR_ENDPOINT_URL
    stub_request(:post, login_url).with { |request| request.body.include?("loginVIA") }.to_return(status: 200, body: login_via_response)
    stub_request(:post, url).with { |request| request.body.include?("getClinicsWithSpecialties") }.to_return(status: 200, body: get_clinics_response)
    vista_session = create(:user)
    params = { access_code: "access", verify_code: "verify", site_code: "site" }
    @vista_session = { vista: VIA_API.authenticate(params)}
  end

  after do
    WebMock.disable!
  end

  describe 'methods', cpp: true do
    it 'Performs the get_clinics_with_specialties operation' do
      target_clinic = "CLINIC ABC"

      response_body = VIA_API::SchedulingService.get_clinics_with_specialties(target_clinic, @vista_session[:vista])
      tagged_hospital_locations = response_body[:get_clinics_with_specialties_response][:tagged_hospital_location_array]
      expect(tagged_hospital_locations[:count]).to eq("44")

      hospital_locations_array = tagged_hospital_locations[:locations][:hospital_location_to]
      expect(hospital_locations_array).to be_an_instance_of(Array)
      expect(hospital_locations_array.first.key?(:specialty)).to be_truthy
    end
  end
end
