require 'rails_helper'

require 'via_api.rb'

RSpec.describe 'VIA_API::SchedulingService', cpp: true do

  before do
    WebMock.enable!
    login_via_response = Rails.root.join("spec/support/via_api/login_via_response.xml").read
    get_appointment_types_response = Rails.root.join("spec/support/via_api/get_appointment_types_response.xml").read
    url  = VIA_API::VIA_SCHEDULING_ENDPOINT_URL
    login_url = VIA_API::VIA_EMR_ENDPOINT_URL
    stub_request(:post, login_url).with { |request| request.body.include?("loginVIA") }.to_return(status: 200, body: login_via_response)
    stub_request(:post, url).with { |request| request.body.include?("getAppointmentTypes") }.to_return(status: 200, body: get_appointment_types_response)
    params = { access_code: "access", verify_code: "verify", site_code: "site" }
    @vista_session = { vista: VIA_API.authenticate(params)}
  end

  after do
    WebMock.disable!
  end

  describe 'methods', cpp: true do
    it 'Performs the get_appointment_type operation' do
      response = VIA_API::SchedulingService.get_appointment_types(@vista_session[:vista])
      expect(response[:get_appointment_types_response][:appointment_types_array][:appointment_types][:appointment_types_to]).to be_an_instance_of(Array)
    end
  end
end
