require 'rails_helper'
require 'via_api.rb'


# the actual unit testing spec
RSpec.describe 'VIA_API::SchedulingService', cpp: true do

  before do
    WebMock.enable!
    login_via_response = Rails.root.join("spec/support/via_api/login_via_response.xml").read
    make_appointment_response = Rails.root.join("spec/support/via_api/make_appointment_response.xml").read
    cancel_appointment_response = Rails.root.join("spec/support/via_api/cancel_appointment_response.xml").read

    url  = VIA_API::VIA_SCHEDULING_ENDPOINT_URL
    login_url = VIA_API::VIA_EMR_ENDPOINT_URL
    stub_request(:post, login_url).with { |request| request.body.include?("loginVIA") }.to_return(status: 200, body: login_via_response)
    stub_request(:post, url).with { |request| request.body.include?("makeAppointment") }.to_return(status: 200, body: make_appointment_response)
    stub_request(:post, url).with { |request| request.body.include?("cancelAppointment") }.to_return(status: 200, body: cancel_appointment_response)

    @test_patient = VIA_API::Models::Veteran.new({
      name: "LastN,FirstN Middle",
      ssn: "101012294",
      gender: "F",
      dob: "19420716.000000",
      age: "74",
      home_address: {
        street_address1: "712 S OAK",
        street_address2: nil,
        street_address3: nil,
        city: "KIMBALL",
        county: "65",
        state: "NEBRASKA",
        zipcode: "69145"
      },
      home_phone: {number: "(444) 444-4444"},
      patient_name: "LastN,FirstN Middle",
      mpi_pid: "1009609054",
      mpi_checksum: "897943",
      local_pid: "7177262",
      confidentiality: {tag: "0"},
      patient_flags: {count: "0"}
    })
    params = { access_code: "access", verify_code: "verify", site_code: "site" }
    @vista_session = { vista: VIA_API.authenticate(params)}
    @test_clinic_id = "325"
  end

  after do
    WebMock.disable!
  end

  describe 'methods', cpp: true do
    it 'Performs the make_appointment operation' do
      appointment_time = Time.new(2017, 1, 1, 15, 0, 0)  # 1/1/17 3:00 PM
      response = VIA_API::SchedulingService.make_appointment(@test_patient, @test_clinic_id, nil, appointment_time, 'TEST BOOK NOTE', @vista_session[:vista])
      expect(response.first.appointment_type).to eq("REGULAR")
      expect(response.first.purpose).to eq("SCHEDULED VISIT")
      expect(response.first.appointment_length.to_i).to eq(60)
      expect(response.first.book_notes).to eq("TEST BOOK NOTE")  # NOTE: matches make_appointment_response, not param above
    end

    it 'Performs the cancel_appointment operation' do
      response = VIA_API::SchedulingService.cancel_appointment(20170707.103, @test_patient, 1, 1921, 'test reason', 'test remarks', @vista_session[:vista])
      expect(response[0][:purpose].to_i).to eq(1)
      expect(response[0][:reason]).to eq("test reason")
    end
  end
end
