require 'rails_helper'

require 'via_api.rb'

RSpec.describe 'VIA_API::EmrService', cpp: true do

  before do
    WebMock.enable!
    login_via_response = Rails.root.join("spec/support/via_api/login_via_response.xml").read
    get_consults_for_patient_response = Rails.root.join("spec/support/via_api/get_consults_for_patient_response.xml").read
    url  = VIA_API::VIA_EMR_ENDPOINT_URL
    login_url = VIA_API::VIA_EMR_ENDPOINT_URL
    stub_request(:post, login_url).with { |request| request.body.include?("loginVIA") }.to_return(status: 200, body: login_via_response)
    stub_request(:post, url).with { |request| request.body.include?("getConsultsForPatient") }.to_return(status: 200, body: get_consults_for_patient_response)

    @test_patient = VIA_API::Models::Veteran.new({
      name: "LastN,FirstN Middle",
      ssn: "101012294",
      gender: "F",
      dob: "19420716.000000",
      age: "74",
      home_address: {
        street_address1: "712 S OAK",
        street_address2: nil,
        street_address3: nil,
        city: "KIMBALL",
        county: "65",
        state: "NEBRASKA",
        zipcode: "69145"
      },
      home_phone: {number: "(444) 444-4444"},
      patient_name: "LastN,FirstN Middle",
      mpi_pid: "1009609054",
      mpi_checksum: "897943",
      local_pid: "7177262",
      confidentiality: {tag: "0"},
      patient_flags: {count: "0"}
    })
    params = { access_code: "access", verify_code: "verify", site_code: "site" }
    @vista_session = { vista: VIA_API.authenticate(params)}

  end

  after do
    WebMock.disable!
  end

  describe 'methods', cpp: true do
    it 'Performs the get_consults_for_patient operation' do
      response = VIA_API::EmrService.get_consults_for_patient(@test_patient, @vista_session[:vista])
      expect(response.first.title).to eq("PROSTHETICS REQUEST Cons")
      expect(response.first.status).to eq("Complete")
    end
  end
end
