require 'rails_helper'
require 'mvi.rb'


# the actual unit testing spec
RSpec.describe 'MVI Retrieve person', cui: true do

  before do
    WebMock.enable!
  end

  after do
    WebMock.disable!
  end

  describe 'can retrieve a person', cui: true do
    before do
      url = MVI::MVI_ENDPOINT_URL
      retrieve_person_success_response = Rails.root.join("spec/support/mvi/retrieve_person_success_response.xml").read
      stub_request(:post, url).to_return(status: 200, body: retrieve_person_success_response)
    end
    it 'with a valid pid' do
      request_id = "CUI" + SecureRandom.base64(10)
      person_data = MVI.retrieve_person("32326950", request_id)
      
      person_firstname = person_data.dig(:patient, :patient_person, :name, :given)
      person_familyname = person_data.dig(:patient, :patient_person, :name, :family)
      
      expect(person_firstname).to eq("BOB")
      expect(person_familyname).to eq("ADELSON")
    end
  end

  describe 'will provie an error response', cui: true do  
    before do 
      url = MVI::MVI_ENDPOINT_URL
      retrieve_person_not_found_response = Rails.root.join("spec/support/mvi/retrieve_person_not_found_response.xml").read
      stub_request(:post, url).to_return(status: 200, body: retrieve_person_not_found_response)
    end
    it 'with an invalid pid' do
      request_id = "CUI" + SecureRandom.base64(10)
      expect{ MVI.retrieve_person("123456", request_id) }.to raise_error(MVI::MviPersonNotFoundError)
    end
  end
end
