require 'rails_helper'

RSpec.describe ScarHeadFaceNeckEvaluationPresenter do
  context "#to_xml" do
    before do
      schema_xml = XML::Document.file(Rails.root.join("app/xsd/ExamResponse/exchange/ExamResponse-2.0.xsd").to_s)
      @schema = XML::Schema.document(schema_xml)
      @claim = create(:claim, date_of_birth: Date.new(1900))
      @contention = create(:contention)
      @claim.contentions << @contention
      allow_any_instance_of(Evaluation).to receive(:to_pdf) { "" }

      @evaluation_spec = EvaluationSpec.create(spec: File.read("app/exams/scar-or-disfigurement-head-face-or-neck.yml"))
      @evaluation = Evaluation.create(claim: @claim, evaluation_spec: @evaluation_spec, user: create(:user))
      @contention.evaluations << @evaluation

      @spec_json = File.read("spec/evaluations/scar_head.json")
      @evaluation.doc = @spec_json
    end

    # it "should generate valid XML for an ear exam" do
    #   doc = XML::Document.string(@evaluation.to_xml)
    #   doc.validate_schema(@schema)
    # end

    context "IEPD compliance" do
      # the fixture only has these fields filled out:
      let(:fields) { ["painful", "unstable", "scarLength", "scarWidth", "unit", "scarType"] }

      it "should have each field in the XML" do
        doc = Nokogiri::XML(@evaluation.to_xml)
        fields.each do |field|
          expect(doc.xpath("//hfnsf:#{field}").length).to eq 1
        end
      end
    end

    context "when the eval is secondary, we output its parent as well" do
      before do
        user = create(:user)
        claim = create(:claim)
        claim.contentions << create(:contention, history: "This or That")

        dependent_eval = Evaluation.new(claim: claim, evaluation_spec: @evaluation_spec, user: user)
        dependent_eval.doc = @spec_json
        claim.contentions.first.evaluations << dependent_eval

        parent_eval = Evaluation.new(claim: claim, evaluation_spec: @evaluation_spec, completed_at: Time.now, user: user)
        parent_eval.doc = @spec_json
        claim.contentions.first.evaluations << parent_eval

        dependent_eval.primary_evaluation_id = parent_eval.id
        dependent_eval.save

        @evaluation_xml = dependent_eval.to_xml
      end

      # it "should include the parent eval" do
      #   xml = XML::Document.string(@evaluation_xml)
      #   facts = xml.find("//hfnsf:headFaceNeckScarFacts")
      #
      #   expect(facts.length).to eq 2
      #
      #   schema_xml = XML::Document.file(Rails.root.join("app/xsd/ExamResponse/exchange/ExamResponse-2.0.xsd").to_s)
      #   schema = XML::Schema.document(schema_xml)
      #   xml.validate_schema(schema)
      # end
    end
  end
end
