# == Schema Information
#
# Table name: visns
#
#  id         :integer          not null, primary key
#  sequence   :string
#  title      :string
#  deleted_at :datetime
#

require 'rails_helper'

RSpec.describe Visn, :type => :model do

  describe "ParanoidModelTest", cpp: true do
    it_behaves_like 'a Paranoid model'
  end

  context "Associations" do
    it "should have many facilities", cpp: true do
	    visn = Visn.reflect_on_association(:facilities)
	    expect(visn.macro).to eq :has_many
    end
  end

  it "should have pre-loaded VISNs", cpp: true do
    expect(Visn.count).to be > 0
  end

  context "Methods" do

    it "should have titles that start with the region number and end with the title", cpp: true do
      Visn.all.each do |visn|
        expect(visn.title).to start_with(visn.region.to_s)
        expect(visn.title).to end_with(visn.name)
      end

    end

  end
end
