function makeTestFields() {
    var $fixture = $('#qunit-fixture');
    $fixture.append(
        '<input id="a-name" value="Brian Eno"/>' +
        '<input id="a-email" value="brian@eno.net">' +
        '<input id="b-name" value="Philip Glass"/>' +
        '<input id="b-email" value="pglass@twelvetone.org">'
    );
}

test('copy fields', function() {
    makeTestFields();
    var fromFields = ['#a-name', '#a-email'];
    var toFields = ['#b-name', '#b-email'];
    Application.copyFields(fromFields, toFields);
    for (var i = 0; i < fromFields.length; i++) {
        var actual = $(fromFields[i]).val();
        var expected = $(toFields[i]).val();
        equal(actual, expected, 'want ' + expected + ', got ' + actual);
    }
});

test('save and restore fields', function() {
    makeTestFields();
    var fromFields = ['#a-name', '#a-email'];
    var toFields = ['#b-name', '#b-email'];
    var save = {};
    for (var i = 0; i < toFields.length; i++) {
        save[toFields[i]] = $(toFields[i]).val();
    }
    Application.saveFields(toFields);
    Application.copyFields(fromFields, toFields);
    Application.restoreFields(toFields);
    for (var i = 0; i < toFields.length; i++) {
        var actual = $(toFields[i]).val();
        var expected = save[toFields[i]];
        equal(actual, expected, 'want ' + expected + ', got ' + actual);
    }
});

test('simple boolean conditional display', function() {
    $('#qunit-fixture').append(
        '<input id=yes name=shown_if_yes value=true type=radio>' +
        '<input id=no name=shown_if_yes value=false type=radio>' +
        '<div id=cond data-display-conditional-on-boolean-field=shown_if_yes>Hello</div>'
    );
    Application.displayConditionalOn();
    ok($('#cond').is(':hidden'), 'should be initially hidden');
    $('#yes').click();
    ok(!$('#cond').is(':hidden'), 'should be shown');
    $('#no').click();
    ok($('#cond').is(':hidden'), 'should be hidden');
});

test('simple text conditional display on select box', function() {
    $('#qunit-fixture').append(
        '<select id=dropdown name=dropdown>' +
        '<option value=invalid>-</option>' +
        '<option value=valid_one>valid option one</option>' +
        '<option value=valid_two>valid option two</option>' +
        '<option value=invalid_two>invalid option</option>' +
        '</select>' +
        '<div id=cond1 data-display-conditional-on-textual-field="dropdown" data-display-conditional-on-values=\'["valid_one", "valid_two"]\'>Hello</div>' +
        '<div id=cond2 data-display-conditional-on-textual-field="dropdown" data-display-conditional-on-values=\'["valid_one"]\'>Hello</div>'
    );
    Application.displayConditionalOn();
    ok($('#cond1').is(':hidden'), 'should be initially hidden');
    ok($('#cond2').is(':hidden'), 'should be initially hidden');
    $('[name=dropdown]').val('valid_one');
    $('#dropdown').trigger('change');
    ok(!$('#cond1').is(':hidden'), 'should be shown');
    ok(!$('#cond2').is(':hidden'), 'should be shown');
    $('[name=dropdown]').val('invalid_two');
    $('#dropdown').trigger('change');
    ok($('#cond1').is(':hidden'), 'should be hidden');
    ok($('#cond2').is(':hidden'), 'should be hidden');
    $('[name=dropdown]').val('valid_two');
    $('#dropdown').trigger('change');
    ok(!$('#cond1').is(':hidden'), 'should be shown');
    ok($('#cond2').is(':hidden'), 'should be hidden');
});

test('disable field conditional on another', function() {
    $('#qunit-fixture').append(
        '<input name=disabler value=true type=checkbox>' +
        '<input id=disablee type=text data-disable-conditional-on=disabler>'
    );
    Application.disableConditionalOn();
    ok(!$('#disablee').is(':disabled'), 'should not be disabled');
    $('[name=disabler]').click();
    ok($('#disablee').is(':disabled'), 'should be disabled');
    $('[name=disabler]').click();
    ok(!$('#disablee').is(':disabled'), 'should not be disabled');
});

test('disable field conditional on another, saving and restoring field value on toggle', function() {
    $('#qunit-fixture').append(
        '<input name=disabler value=true type=checkbox>' +
        '<input id=disablee name=disablee type=text data-disable-conditional-on=disabler value="Foo bar baz">'
    );
    Application.disableConditionalOn();
    ok(!$('#disablee').is(':disabled'), 'should not be disabled');
    var expected = $('#disablee').val();
    $('[name=disabler]').click();
    ok($('#disablee').is(':disabled'), 'should be disabled');
    equal($('#disablee').val(), '', 'should have cleared the disabled field');
    $('[name=disabler]').click();
    var actual = $('#disablee').val();
    equal(actual, expected, 'want ' + expected + ', got ' + actual);
});
