# == Schema Information
#
# Table name: providers
#
#  id             :integer          not null, primary key
#  npi            :string           not null
#  name           :string           not null
#  physician_name :string           not null
#  content        :json
#  created_at     :datetime         not null
#  updated_at     :datetime         not null
#  facility_id    :integer
#

FactoryGirl.define do

  get_content = -> (n) do
    fourdigit = (n+3434) % 10000
    {"taxonomies"=>
      [{"state"=>"MD",
        "code"=>"#{fourdigit}C0700X",
        "primary"=>true,
        "license"=>"XX#{fourdigit}",
        "desc"=>"Test Description #{n+123}"}],
     "addresses"=>
      [{"city"=>"CITY#{n}",
        "address_2"=>"",
        "telephone_number"=>"333-555-#{fourdigit}",
        "fax_number"=>"333-556-#{fourdigit}",
        "state"=>"MD",
        "postal_code"=>"21045",
        "address_1"=>"123 SOME PLACE",
        "country_code"=>"US",
        "country_name"=>"United States",
        "address_type"=>"DOM",
        "address_purpose"=>"LOCATION"}],
     "created_epoch"=>1450224000,
     "identifiers"=>[],
     "other_names"=>[],
     "number"=>1710342811,
     "last_updated_epoch"=>1450298884,
     "basic"=>
      {"status"=>"A",
       "credential"=>"TESTCRED#{n}",
       "first_name"=>"SOMEGUY#{n+34}",
       "last_name"=>"JONES#{n}",
       "last_updated"=>"2015-12-16",
       "name"=>"SOMEGUY#{n+34} JONES#{n}",
       "gender"=>"M",
       "sole_proprietor"=>"YES",
       "enumeration_date"=>"2015-12-16"},
     "enumeration_type"=>"NPI-1"
   }
  end

  # Default consultation: use default (first) veteran, default consultation
  # order type ("Evaluate and Recommend"), and random care category.
  # ConsultationOrder and CareCategory get preloaded when running `rake db:seed`.
  # Content gets sequence-generated and contains all sub-fields:
  # taxonomies, addresses, etc.
  factory :provider do
    facility  { Facility.first || association(:facility) }
    sequence(:npi)            {|n| (1_710_342_811 + (89 * n)).to_s }
    sequence(:name)           {|n| "PROVIDER#{n} NAME" }
    sequence(:physician_name) {|n| "Provider#{n} Name, MD" }
    sequence(:content)        {|n| get_content.call(n) }
  end

  trait :with_visn_by_name do
    transient do
      visn_name nil
    end
    after(:create) do |saved_provider, evaluator|
      visn_to_add = Visn.where(name: evaluator.visn_name).first
      saved_provider.facility = create(:facility, visn_id: visn_to_add.id)
      saved_provider.save!
    end
  end

  trait :with_facility_and_visn_number do
    transient do
      facility_name nil
      visn_number nil
    end
    after(:create) do |saved_provider, evaluator|
      visn_to_add = Visn.where(region: evaluator.visn_number).first
      saved_provider.facility = create(:facility, name: evaluator.facility_name, visn_id: visn_to_add.id)
      saved_provider.save!
    end
  end

end
