# == Schema Information
#
# Table name: diagnoses
#
#  id                    :integer          not null, primary key
#  name                  :string
#  label                 :string
#  code                  :string
#  diagnosis_modifier_id :integer
#  created_at            :datetime         not null
#  updated_at            :datetime         not null
#  minor_system_id       :integer
#

FactoryGirl.define do
  factory :diagnosis_modifier do
    name "barney"
    label "Barney Rubble"
    mod_type "checkbox"
    list_values ["First", "Second"]
  end
  
  factory :diagnosis do
    name "liver_injury_residuals"
    label "Has the Veteran had residual injuries of the liver?"
    code "7311"
    association :diagnosis_modifier
  end
end
