# == Schema Information
#
# Table name: claims
#
#  id                         :integer          not null, primary key
#  completed_at               :datetime
#  created_at                 :datetime
#  updated_at                 :datetime
#  patient_ssn                :string
#  file_number                :string
#  first_name                 :string
#  middle_name                :string
#  last_name                  :string
#  date_of_birth              :date
#  facility_name              :string
#  facility_number            :string
#  exam_request_data          :text
#  vbms_claim_id              :string
#  claim_date                 :date
#  email                      :string
#  phone_number               :string
#  benefit_type               :string
#  label                      :string
#  end_product_code           :string
#  edipi                      :string
#  participant_id             :string
#  gender                     :string
#  vista_ien                  :string
#  alternate_phone            :string
#  integration_control_number :string
#  poa_vso_name               :string
#  poa_vso_number             :string
#  regional_office_id         :integer
#

# Read about factories at https://github.com/thoughtbot/factory_girl

FactoryGirl.define do
  factory :claim do
    first_name "Joe"
    last_name "Veteran"
    patient_ssn "123456789"
    file_number "123456789"
    date_of_birth "1990-01-01"
    exam_request_data {{"ExamRequest" => "Hi. I am exam request data"}}
  end

  factory :claim_without_exam_request_data, class: Claim do
    first_name "Mary"
    last_name "Veteran"
    patient_ssn "123456798"
    file_number "123456798"
    date_of_birth "1990-01-01"
  end

end
